<?php

/**
 * This is the model class for table "{{_product_category}}".
 *
 * The followings are the available columns in table '{{_product_category}}':
 * @property string $id
 * @property string $category_name
 * @property string $isActive
 */
class ProductCategory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_category}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('category_name,category_description,user_group_id,product_group_id', 'required'),
			//array('category_name','unique'),
			array('category_name', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, category_name, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
					 'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
					 'productGroup' => array(self::BELONGS_TO, 'ProductGroup', 'product_group_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_group_id'=>'Sub Category',
			'product_group_id'=>'Product Group', 
			'category_name' => 'Product Sub Group',
			'category_description' => 'Description',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $user = trim(Yii::app()->request->getParam('user'));
                $cat = trim(Yii::app()->request->getParam('cat'));
                $pro_group = trim(Yii::app()->request->getParam('pro_group'));
		$criteria=new CDbCriteria;

		$criteria->compare('t.id',$this->id,true);
		
		$criteria->with	=	array('userGroup','productGroup');
		
		$criteria->compare('t.user_group_id',$this->user_group_id,true);
		$criteria->compare('t.product_group_id',$this->product_group_id,true);
		$criteria->compare('t.category_name',$this->category_name,true);
		$criteria->compare('t.isActive',$this->isActive,true);
                if(!empty($user))
                {
                $criteria->addCondition('t.user_group_id='.$user,'AND');
                }
                if(!empty($cat))
                {
                $criteria->addCondition('t.category_name like "%'.$cat.'%"','AND');
                }
                if(!empty($pro_group))
                {
                $criteria->addCondition('t.product_group_id='.$pro_group,'AND');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),'pagination'=>false
//			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	public function getGroupName()
	{
		return $this->category_name.' ('.$this->productGroup->product_group_name."->".$this->userGroup->group_name.')';
	}
	
	//Get Category(s)
	//param group id, returning model
	public function getProductCategory($user_group_id=null,$product_group_id=null,$getAll=false)
	{
		$condition	=	'isActive =  "Y"';
		if($user_group_id!=null || $product_group_id!=null)
		{
			if($product_group_id!=null) 
			$condition	.=	' AND product_group_id =  '.$product_group_id;
			if($user_group_id!=null) 
			$condition	.=	' AND user_group_id =  '.$user_group_id;
			
			$model		=	ProductCategory::model()->findAll(array('condition'=>$condition,'order'=>'category_name'));
			return array('0'=>'No category')+CHtml::listData($model, 'id', 'GroupName');
		}
		if($getAll)
		{
			$model		=	ProductCategory::model()->findAll(array('condition'=>$condition,'order'=>'category_name'));
			return array('0'=>'No category')+CHtml::listData($model, 'id', 'GroupName');
		}
		return array();
	}
}