<?php

/**
 * This is the model class for table "{{_page}}".
 *
 * The followings are the available columns in table '{{_page}}':
 * @property integer $id
 * @property integer $menu_id
 * @property string $content
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MenuItem $menu
 */
class Page extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Page the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_page}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('menu_id, page_title, content', 'required'),
			array('menu_id', 'numerical', 'integerOnly'=>true),
			array('menu_id', 'unique','message' => Yii::t('default', 'Page already created for this menu item')),
			array('isActive,external_link', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, menu_id, content, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'menu' => array(self::BELONGS_TO, 'MenuItem', 'menu_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'menu_id' => 'Menu',
			'page_title'=>'Page Title',
			'content' => 'Content',
			'isActive' => 'Is Active',
			'external_link'=>'Is this a hyper link (http://www/example.com)'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $menu_id= Yii::app()->request->getParam('menu_id');
				if(!empty($menu_id))
				$menu_id= trim(Yii::app()->request->getParam('menu_id'));
                $page_title= Yii::app()->request->getParam('page_title');
				if(!empty($page_title))
				$page_title= trim(Yii::app()->request->getParam('page_title'));
             //   $isActive= trim(Yii::app()->request->getParam('isActive'));

		$criteria=new CDbCriteria;
		$criteria->with	=	array('menu');
		$criteria->compare('id',$this->id);
		$criteria->compare('menu.parent_id',43);
		$criteria->compare('menu_id',$this->menu_id);
		$criteria->compare('menu_id','<>43');
		$criteria->compare('page_title',$this->page_title);		
		$criteria->compare('content',$this->content,true);
		//$criteria->compare('isActive',$this->isActive,true);

                if(!empty($menu_id))
                {
                    $criteria->addCondition('t.menu_id like "%'.$menu_id.'%"','AND');
                }
                if(!empty($page_title))
                {
                    $criteria->addCondition('t.page_title like "%'.$page_title.'%"','AND');
                }
//                if(!empty($isActive))
//                {
//                    $criteria->addCondition('t.isActive like "%'.$isActive.'%"','AND');
//                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'pagination'=>false,
		));

/**		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));*/
	}
}