<?php

/**
 * ContactForm class.
 * ContactForm is the data structure for keeping
 * contact form data. It is used by the 'contact' action of 'SiteController'.
 */
class ContactForm extends CFormModel
{
	public $first_name;
	public $last_name;
	public $product_name;
	public $issue;
	public $email;
	public $country;
	public $re_enter_email_address;
	public $problem_category;
	public $operating_system;
	public $hardware_version;
	public $firmware_version;
	public $serial_number;
	public $phone_number;
	public $company_number;
	public $others;
	public $verifyCode;

	/**
	 * Declares the validation rules.
	 */
	public function rules()
	{
		return array(
			// name, email, subject and body are required
			array('first_name, last_name, product_name, issue, email, country, re_enter_email_address, problem_category', 'required'),
			array('operating_system, hardware_version, firmware_version, serial_number, phone_number, company_number,others','length', 'max'=>'10000'),
			// email has to be a valid email address
			array('email', 'email'),
			// verifyCode needs to be entered correctly
			array('verifyCode', 'captcha', 'allowEmpty'=>!CCaptcha::checkRequirements()),
		);
	}

	/**
	 * Declares customized attribute labels.
	 * If not declared here, an attribute would have a label that is
	 * the same as its name with the first letter in upper case.
	 */
	public function attributeLabels()
	{
		return array(
			'verifyCode'=>'Verification Code',
		);
	}
}