<?php

class SiteController extends Controller {

    /**
     * Declares class-based actions.
     */
    public $layout = "layout";
    public $pageTitle = "Dlink";

    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }

    public function actions() {
        return array(
            // captcha action renders the CAPTCHA image displayed on the contact page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
            ),
                // page action renders "static" pages stored under 'protected/views/site/pages'
                // They can be accessed via: index.php?r=site/page&view=FileName
                //'page'=>array(
//				'class'=>'CViewAction',
//			),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            // print_r($error);
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    public function actionBuy() {
        $this->render('where_to_buy');
    }

    public function actionProduct() {
        $this->render('products');
    }

    public function actionProductlist() {
        $this->render('product_page');
    }

    public function actionSubscribe() {

        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        /* Count of POST */
        if (count($_POST) > 0) {
            $model = new NewsLetterEmails();

            $model->email_id = $_POST['emailsend'];

            $email_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM ptp_news_letter_emails WHERE email_id="' . $_POST['emailsend'] . '"')->queryScalar();

            if ($email_count == 0) {
                $model->save();
            }

            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $this->render('404');
        }
        /* $mail = htmlspecialchars(Yii::app()->request->getParam('emailsend'));
          if($mail!='')
          {
          if (!filter_var($mail, FILTER_VALIDATE_EMAIL)) {
          header('Location: http://dlinkmea.com/site/');
          }
          else {
          $message="$mail has registered for the email newsletter";
          mail('mereena.vinod@mailbluesky.com', 'Email Newsletter', $message);
          header('Location: http://dlinkmea.com/site/');
          }
          }
          else {
          $message="$mail has registered for the email newsletter";
          mail('mereena.vinod@mailbluesky.com', 'Email Newsletter', $message);
          header('Location: http://dlinkmea.com/site/');
          } */
//    mail('sub@dlink-me.com', 'Email Newsletter', $message);
    }

    public function actionNews() {
        $this->render('new_head');
    }

    public function actionNewsdata() {
        $this->pageTitle .= ' - Press releases';
        $criteria = new CDbCriteria();
        $criteria->condition = 'isActive = :isActive';
        $criteria->order = 'date desc';
        $criteria->params = array(':isActive' => 'Y');
        $criteria->select = 'id,date,title_of_news,content';

        /*  $user = Yii::app()->db->createCommand()
          ->select('id, username, profile')
          ->from('tbl_user u')
          ->join('tbl_profile p', 'u.id=p.user_id')
          ->where('id=:id', array(':id'=>$id))
          ->queryRow(); */

        /* $p = new CHtmlPurifier();
          $news_seacrh_term = $p->purify($news_seacrh_term); */

        $_GET = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0 && $_POST['YII_CSRF_TOKEN'] === Yii::app()->request->csrfToken) {
            $news_seacrh_term = preg_replace('#[^a-zA-Z0-9_+-]#', '', trim($_POST['term']));
            if (!empty($news_seacrh_term)) {
                $criteria->condition .= ' AND ( title_of_news LIKE "%' . $news_seacrh_term . '%" OR content LIKE "%' . $news_seacrh_term . '%")';
            }
        }
        $item_count = News::model()->count($criteria);

        if ($item_count > 0) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $this->renderPartial('news_events', array(
                'model' => News::model()->findAll($criteria), // must be the same as $item_count
                'item_count' => $item_count,
                'items_count' => $item_count,
            ));
        } else {

            echo 'No Results found';
        }
    }

    public function actionCategory() {

        //$arr_data   = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING); // php 5
        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        //if(count($arr_data) > 0){  // php 5
        if ($arr_data !== null) {
            $enc_string = $arr_data['qr'];

            //echo $enc_string;exit;

            $decrypted_string = Yii::app()->controller->encryptCipherDecrypt($enc_string, 'd');

            //$decrypted_string = Yii::app()->controller->decrypt($enc_string, ENCRYPTION_KEY);

            $category_id = 0;
            $sub_category_id = 0;
            $product_category_id = 0;
            $product_sub_category_id = 0;

            if (strpos($decrypted_string, '#####') !== false) {
                $arr_pars_data = explode("#####", $decrypted_string);
                $category_id = (int) $arr_pars_data[0];
                if (isset($arr_pars_data[2])) {
                    $sub_category_id = (int) $arr_pars_data[1];
                }
                if (isset($arr_pars_data[2])) {
                    $product_category_id = (int) $arr_pars_data[2];
                }
                if (isset($arr_pars_data[3])) {
                    $product_sub_category_id = (int) $arr_pars_data[3];
                }
            } else {

                $category_id = (int) $decrypted_string;
            }


            if ($category_id > 0) {

                $category_name = Category::model()->findByPk($category_id)->category;

                $this->pageTitle .= ' - Products | ' . $category_name;
                $condition = "t.isActive='Y' AND t.category_id=" . $category_id;
                $subCategory = SubCategory::model()->findAll(array('condition' => $condition, 'order' => 'sort_order'));
                $j = 0;
                $category = array();
                foreach ($subCategory as $eachSubCategory) {

                    $condition = 't.isActive="Y" AND
                                    ((t.category_id=' . $category_id . ' AND  t.sub_category_id=' . (int) $eachSubCategory->id . ') OR
                                    (productMapping.category_id=' . $category_id . ' AND productMapping.sub_category_id=' . (int) $eachSubCategory->id . '))';
                    $p = Product::model()->with('productMapping')
                            ->together(true)
                            ->find(array(
                        'select' => '*, rand() as rand',
                        'order' => 'rand',
                        'condition' => $condition));
                    if ($p != null) {
                        $category[$j]['id'] = (int) $eachSubCategory->id;
                        $category[$j]['name'] = $eachSubCategory->sub_category;
                        $category[$j]['image'] = $eachSubCategory->image;
                        $category[$j]['description'] = $eachSubCategory->description;
                        //$category[$j]['link'] = Yii::app()->createUrl('site/product_category', array('category_id' => $category_id, 'sub_category_id' => $eachSubCategory->id));
                        //$category[$j]['link'] = Yii::app()->createUrl('site/products', array('category_id' => $category_id, 'sub_category_id' => $eachSubCategory->id));
                        $category[$j]['link'] = Yii::app()->createUrl('site/products');
                        $j++;
                    }
                }


                if (count($category) > 0) {


                    $this->render('product_category', array(
                        'category' => $category,
                        'category_id' => $category_id,
                        'sub_category_id' => $sub_category_id,
                        'product_category_id' => $product_category_id,
                        'product_sub_category_id' => $product_sub_category_id
                    ));
                }
            }
        } else {
            $this->render('404');
        }
    }

    public function actionProduct_category($category_id = null, $sub_category_id = null, $name = null) {

        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);

        if (count($arr_data) > 0) {
            // echo($sub_category_id);
            $subcategoryName = SubCategory::model()->findByPk((int) $sub_category_id)->sub_category;
            $this->pageTitle .= ' | Products - ' . $subcategoryName;
            if ($sub_category_id > 0) {
                $condition = "t.isActive='Y' AND t.category_id=" . (int) $category_id;
                if ($sub_category_id > 0)
                    $condition .= " AND t.sub_category_id=" . (int) $sub_category_id;
                $categories = ProductCategory::model()->findAll(array('condition' => $condition, 'order' => 'sort_order'));
                $j = 0;

                foreach ($categories as $i => $eachProductCategory) {
                    $condition = '(t.isActive="Y" AND t.category_id=' . (int) $category_id . ' AND t.product_category_id =' . (int) $eachProductCategory->id;
                    if ($sub_category_id != null)
                        $condition .= " AND t.sub_category_id=" . (int) $sub_category_id;
                    $condition .= " ) OR ";
                    $condition .= '(t.isActive="Y" AND productMapping.category_id=' . (int) $category_id . ' AND productMapping.product_category_id =' . (int) $eachProductCategory->id;
                    if ($sub_category_id != null)
                        $condition .= " AND productMapping.sub_category_id=" . (int) $sub_category_id;
                    $condition .= ")";
                    $p = Product::model()->with('productMapping')->together(true)->find(array('select' => '*, rand() as rand', 'order' => 'rand', 'condition' => $condition));
                    if ($p != null) {
                        $category[$j]['name'] = $eachProductCategory->product_category;
                        $category[$j]['image'] = $eachProductCategory->image;
                        $category[$j]['description'] = $eachProductCategory->description;
                        $category[$j]['link'] = Yii::app()->createUrl('site/products', array('category_id' => $category_id, 'sub_category_id' => (int) $sub_category_id, 'product_category_id' => (int) $eachProductCategory->id, 'name' =>
                            preg_replace('/[^a-z0-9_]/', '', strtolower(str_replace(" ", "_", $eachProductCategory->product_category)))));
                        $j++;
                    }
                }

                if (count($category) > 0) {
                    /* $allProductsUnderUserGroup = Product::model()->with('productCategory', 'productMapping')
                      ->together(true)
                      ->findAll(array('condition' => 't.isActive="Y" AND (
                      t.user_group_id=' . $category_id . ' AND
                      t.product_group_id=' . $product_group_id . ')  OR (
                      productMapping.user_group_id=' . $user_group_id . ' AND
                      productMapping.product_group_id=' . $product_group_id . ')',
                      'order' => 't.product_name',
                      //'group'=>'t.type_id,productMapping.type_id,t.product_generic_name',
                      ));

                      foreach ($allProductsUnderUserGroup as $eachProduct) {
                      $productsByType[$eachProduct->type_id][] = $eachProduct;
                      }
                      ksort($productsByType); */

                    $this->render('product_category', array(
                        'category' => $category,
                        'productsByType' => $productsByType,
                    ));
                } else {
                    $this->redirect(array('products',
                        'name' => $name,
                        'sub_category_id' => $sub_category_id,
                        'category_id' => $category_id));
                }
            }
        } else {
            $this->render('404');
        }
    }

    public function actionProducts() {


        //$arr_data   = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);//php 5
        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        if (!empty($arr_data)) {

            $enc_string = $arr_data['qr'];

            if ($enc_string != "") {

                $decrypted_string = Yii::app()->controller->encryptCipherDecrypt($enc_string, 'd');

                $category_id = 0;
                $sub_category_id = 0;
                $product_category_id = 0;
                $product_sub_category_id = 0;

                if (strpos($decrypted_string, '#####') !== false) {
                    $arr_pars_data = explode("#####", $decrypted_string);
                    $category_id = (int) $arr_pars_data[0];
                    $sub_category_id = (int) $arr_pars_data[1];
                    //echo "hiii".$sub_category_id."<br>";
                    if (isset($arr_pars_data[2])) {
                        $product_category_id = (int) $arr_pars_data[2];
                    }
                    if (isset($arr_pars_data[3])) {
                        $product_sub_category_id = (int) $arr_pars_data[3];
                    }
                }
                if ((int) $category_id > 0) {
                    $CategoryName = Category::model()->findByPk($category_id)->category;
                    $this->pageTitle .= ' - Products | ' . $CategoryName;
                    $condition = 't.isActive="Y" AND ( t.category_id=' . $category_id . ' OR productMapping.category_id=' . $category_id . ')';
                    if ((int) $sub_category_id != 0)
                        $condition .= ' AND ( t.sub_category_id=' . $sub_category_id . ' OR productMapping.sub_category_id=' . $sub_category_id . ')';
                    if ((int) $product_category_id != 0)
                        $condition .= ' AND (t.product_category_id=' . $product_category_id . ' OR  productMapping.product_category_id=' . $product_category_id . ')';
                    if ((int) $product_sub_category_id != 0)
                        $condition .= ' AND (t.product_sub_category_id=' . $product_sub_category_id . ' OR productMapping.product_sub_category_id=' . $product_sub_category_id . ')';
                    $products = Product::model()->with('productMapping')->together(true)->findAll(array('condition' => $condition, 'order' => 'product_name DESC'));

                    $productsByType = array();
                    foreach ($products as $eachProduct) {
                        $productsByType[$eachProduct->product_sub_category_id][] = $eachProduct;
                    }
                    if (count($productsByType) > 0) {
                        ksort($productsByType);
                    }
                    //$template	=	Settings::model()->findByPK(1)->product_list_temp;
                    $template = 'productlist';

                    $this->render($template, array(
                        'category_id' => $category_id,
                        'sub_category_id' => $sub_category_id,
                        'product_category_id' => $product_category_id,
                        'product_sub_category_id' => $product_sub_category_id,
                        'productsByType' => $productsByType,
                        'CategoryName' => $CategoryName));
                } else {
                    $this->render('404');
                }
            } else {
                $this->render('404');
            }
        } else {
            $this->render('404');
        }
    }

    public function actionAllproducts() {
        $criteria = new CDbCriteria();
        $criteria->condition = 't.isActive = :isActive';
        $criteria->order = 'maincategory.sort_order,subcategory.sort_order';
        $criteria->params = array(':isActive' => 'Y');
        $item_count = Product::model()->with('maincategory', 'category', 'subcategory')->count($criteria);

        $pages = new CPagination($item_count);
        $pages->setPageSize(/* Yii::app()->params['listPerPage'] */24);
        $pages->applyLimit($criteria);  // the trick is here!

        $this->render('allproducts', array(
            //'model' => Product::model()->findAll($criteria), // must be the same as $item_count
            'model' => Product::model()->with('maincategory', 'category', 'subcategory')->findAll($criteria), // must be the same as $item_count
            'item_count' => $item_count,
            'page_size' => /* Yii::app()->params['listPerPage'] */24,
            'items_count' => $item_count,
            'pages' => $pages,
        ));
    }

    public function actionPress_releases($news_search_term = null) {
        $this->pageTitle .= ' - Press releases';
        $criteria = new CDbCriteria();
        $criteria->condition = 'isActive = :isActive';
        $criteria->order = 'date desc';
        $criteria->params = array(':isActive' => 'Y');
        $p = new CHtmlPurifier();
        $news_search_term = $p->purify($news_search_term);
        if ($news_search_term != null && trim($news_search_term) != '')
            $criteria->condition .= ' AND ( title_of_news LIKE "%' . $news_search_term . '%" OR content LIKE "%' . $news_search_term . '%")';

        $item_count = News::model()->count($criteria);

        $pages = new CPagination($item_count);
        $pages->setPageSize(/* Yii::app()->params['listPerPage'] */10);
        $pages->applyLimit($criteria);  // the trick is here!

        $this->render('news_events', array(
            'model' => News::model()->findAll($criteria), // must be the same as $item_count
            'item_count' => $item_count,
            'page_size' => /* Yii::app()->params['listPerPage'] */10,
            'items_count' => $item_count,
            'pages' => $pages,
        ));
    }

    public function actionContactus() {
        $this->pageTitle .= ' - Contact us';
        //$this->layout	=	'common_layout';

        $model = new ContactUs;
        if (isset($_POST['ContactUs']) && isset($_POST['YII_CSRF_TOKEN']) && $_POST['YII_CSRF_TOKEN'] === Yii::app()->request->csrfToken) {

            if (isset($_POST['g-recaptcha-response'])) {
                $captcha = $_POST['g-recaptcha-response'];
            }

            if (!$captcha) {
                $jsonData['status'] = 'nocaptcha';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            } else {
                $google_secret_key = "6Lfg2yQTAAAAAE_vZSob16lhM-McyXeEJYArMnla";
                $response = json_decode(file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=" . $google_secret_key . "&response=" . $captcha . "&remoteip=" . $_SERVER['REMOTE_ADDR']), true);
                if ($response['success'] == false) {
                    $jsonData['status'] = 'spammer';
                    echo CJSON::encode($jsonData);
                    Yii::app()->end();
                } else {


                    $model->attributes = $_POST['ContactUs'];
                    if ($model->validate()) {

                        /* $mailContent = array();
                          $mailContent['name'] = $model->name;
                          $mailContent['phone'] = $model->phone;
                          $mailContent['email'] = $model->email;
                          $mailContent['country'] = $model->country;
                          $mailContent['query'] = $model->query ;


                          $message = new YiiMailMessage;
                          $message->view = 'contactmailtemplate';

                          $message->setBody(array('mailContent' => $mailContent), 'text/html');
                          $message->subject = 'Contact request from Dlink site';

                          $message->from = $model->email;
                          $message->addTo('mereena.vinod@mailbluesky.com');
                          //$message->addTo('info.me@me.dlink.com');

                          echo '<pre>';
                          print_r($message);
                          //$swiftAttachment = Swift_Attachment::fromPath('img/front/logo.png'); // create a Swift Attachment
                          //$message->attach($swiftAttachment);
                          Yii::app()->mail->send($message);
                          mail('mereena.vinod@mailbluesky.com', 'Hi', 'dfdfd');
                          exit; */
                        $body = '<table width="100%" border="0" cellpadding="5" cellspacing="2"><tr>
    			     <td width="44%">Name</td><td width="2%">:</td>
    			     <td width="54%">' . $model->name . '</td></tr><tr>
			     <td>Phone</td><td width="2%">:</td>
			     <td>' . $model->phone . '</td></tr><tr>
		             <td>E-mail </td><td width="2%">:</td>
		             <td>' . $model->email . '</td></tr><tr>
		             <td>Country</td><td width="2%">:</td>
		             <td>' . $model->country . '</td></tr><tr>
		             <td>Query</td><td width="2%">:</td>
                             <td>' . $model->query . '</td></tr>
                         </table>';

                        //$adminMail = Yii::app()->params['adminEmail'];
                        $adminMail = 'noreply@me.dlink.com';
                        $name = '=?UTF-8?B?' . base64_encode('Contact Us:Dlinkmea.com') . '?=';
                        $subject = '=?UTF-8?B?' . base64_encode('Contact Us:Dlinkmea.com') . '?=';
                        $headers = "From: $name <{$adminMail}>\r\n" .
                                "Reply-To: {$model->email}\r\n" .
                                "MIME-Version: 1.0\r\n" .
                                "Content-type: text/html; charset=UTF-8";

                        //$to = "akhil@mailbluesky.com";

                        $to = "info.me@me.dlink.com";
                        /* UAE -> info.me@me.dlink.com

                          - Egypt -> info.eg@me.dlink.com

                          - KSA -> info.sa@me.dlink.com

                          - Pakistan -> info.pk@me.dlink.com

                          - Iran -> info.ir@me.dlink.com

                          - Morocco -> info.ma@me.dlink.com

                          - Lebanon -> info.lb@me.dlink.com

                          - Kenya -> info.ea@me.dlink.com

                          - Nigeria -> info.ng@me.dlink.com

                          - Others -> info.me@me.dlink.com */

                        /* switch ($model->country) {
                          case 'UAE':
                          $to	=	"info.me@me.dlink.com";
                          $to = "mereena.vinod@mailbluesky.com";
                          break;
                          case 'Egypt':
                          $to	=	"info.eg@me.dlink.com";
                          break;
                          case 'KSA':
                          $to	=	"info.sa@me.dlink.com";
                          break;
                          case 'Pakistan':
                          $to	=	"info.pk@me.dlink.com";
                          break;
                          case 'Iran':
                          $to	=	"info.ir@me.dlink.com";
                          break;
                          case 'Morocco':
                          $to	=	"info.ma@me.dlink.com";
                          break;
                          case 'Lebanon':
                          $to	=	"info.lb@me.dlink.com";
                          break;
                          case 'Kenya':
                          $to	=	"info.ea@me.dlink.com";
                          break;
                          case 'Nigeria':
                          $to	=	"info.ng@me.dlink.com";
                          break;
                          case 'Others':
                          $to	=	"info.me@me.dlink.com";
                          break;
                          } */
                        mail($to, $subject, $body, $headers);
                        Yii::app()->user->setFlash('contact', 'Thank you for contacting us. We will respond to you as soon as possible1.');
                        $this->refresh();
                    }
                }
            }
        }
        $this->render('pages/contactus', array('model' => $model));
    }

    public function actionWhere_to_buy() {

        if (Yii::app()->request->csrfToken) {
            $this->pageTitle .= ' - Where to buy, store locations';
            $this->render('where_to_buy');
        } else
            $this->render('404');
    }

    public function actionPage() {

        //$arr_data   = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING); //PHP 5

        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        if (isset($_GET['id']) && $_GET['id'] > 0) {
            $about_page_id = (int) $_GET['id'];
        }
        //echo $about_page_id;
        if ($arr_data !== null || $about_page_id > 0) {

            if (isset($arr_data['qr']) && $arr_data['qr'] != "") {
                $enc_string = $arr_data['qr'];
                $decrypted_string = Yii::app()->controller->encryptCipherDecrypt($enc_string, 'd');
                $about_page_id = (int) $decrypted_string;
            }


            $model = Page::model()->findByAttributes(array('menu_id' => $about_page_id));
            if ($model === null) {
                $model->page_title = "Page not exist";
                $this->render('404');
            } else {
                $this->pageTitle .= ' - ' . $model->page_title;
                $this->render('pages/pages', array('model' => $model));
            }
        } else {
            $this->render('404');
        }
    }

    public function actionSupport() {
        try {



            $model = new Support();
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $_GET = filter_input_array(INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            //echo "hi";exit;
            if (isset($_POST['Support'])) {

                $model->attributes = $_POST['Support'];
                if ($model->validate()) {
                    if ($_POST['radio'] == "login")
                        $this->redirect(Yii::app()->baseUrl . '/../support/index.php/site/login?HfGty=' . base64_encode(json_encode($model->attributes)) . '#tologin');
                    else
                        $this->redirect(Yii::app()->baseUrl . '/../support/index.php/site/login?HfGty=' . base64_encode(json_encode($model->attributes)) . '#toregister');
                }
            }
            $id = isset($_GET['pid']) ? $_GET['pid'] : "";
            //echo $id;exit;
            $downloadbles = array();
            if ($id > 0) {
                $modelProductDownloadableRelation = ProductDownloadableRelation::model()->with('downloadable')->findAll(array('condition' => 'product_id=' . (int) $id));

                $modelProductDownloadable = ProductDownloadable::model()->findAll(array('condition' => 'isActive="Y"'));

                if (!empty($modelProductDownloadableRelation) && !empty($modelProductDownloadable)) {
                    foreach ($modelProductDownloadableRelation as $eachProductsd) {
                        foreach ($modelProductDownloadable as $eachDownloadable) {
                            if ($eachProductsd->item_id == $eachDownloadable->id) {
                                $downloadbles[$eachDownloadable->id]['item_value'][] = $eachProductsd->item_value;
                                $downloadbles[$eachDownloadable->id]['files_available'][] = $eachProductsd->files_available;
                                $downloadbles[$eachDownloadable->id]['downloadbal_title'] = $eachDownloadable->item_name;
                            }
                        }
                    }
                }
            }
            $this->render('pages/support1', array('model' => $model, 'downloadbles' => $downloadbles));
        } catch (Exception $exc) {
            echo $exc->getTraceAsString();
        } finally {

        }
    }

    public function actionWhydlink() {
        $this->pageTitle .= ' - Why Dlink';
        $this->render('pages/whydlink');
    }

    public function actionTechnology() {
        $this->pageTitle .= ' - Technology';
        $this->render('pages/technology');
    }

    public function actionProducts_info() {
        $this->pageTitle .= ' - Products';
        $this->render('pages/products_info');
    }

    public function actionCustomerEquipment() {
        $this->pageTitle .= ' - Customer Equipment';
        $this->render('pages/customerEquipment');
    }

    public function actionContact_info() {
        $this->pageTitle .= ' - Contact';
        $this->render('pages/contact_info');
    }

    public function actionSearch() {
        $filter = '';
        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        $seacrh_term = preg_replace('#[^a-zA-Z0-9_ +-]#', '', $arr_data['seacrh_term']);
        if (isset($array['filter'])) {
            $filter = preg_replace('#[^a-zA-Z0-9_ +-]#', '', $arr_data['filter']);
        }
        if (isset($array['product'])) {
            $product = preg_replace('#[^a-zA-Z0-9_ +-]#', '', $arr_data['product']);
        }

        if (isset($array['resource'])) {
            $resource = preg_replace('#[^a-zA-Z0-9_ +-]#', '', $arr_data['resource']);
        }

        if (isset($array['event'])) {
            $event = preg_replace('#[^a-zA-Z0-9_ +-]#', '', $arr_data['event']);
        }

        if (count($arr_data) > 0 && !empty($seacrh_term)) {

            $this->pageTitle .= ' - Search site';
            $products = array();
            $events = array();
            $resources = array();
            if (!empty($seacrh_term)) {
                if (empty($filter) || empty($product)) {

                    // create string for PDO::prepare()
                    //$sql = 'SELECT * FROM testTable WHERE ';
                    $wheres = $values = array();
                    foreach (array_filter(explode(' ', $seacrh_term), 'strlen') as $keyword) {
                        $wheres[] = '(product_generic_name LIKE "%' . htmlspecialchars($keyword) . '%" OR product_name LIKE "%' . htmlspecialchars($keyword) . '%")';
                        $values[] = '%' . addcslashes($keyword, '%_\\') . '%'; // this is escape for LIKE search
                    }

                    $sql = $wheres ? implode(' AND ', $wheres) : '1';

                    $products = Product::model()->with('productcategory')->findAll(array(
                        'condition' => 't.isActive="Y" AND ( ' . $sql . ')',
                        'order' => 'product_sub_category_id,t.product_name'));
                }

                if (!empty($event))
                    $events = Events::model()->findAll(array('condition' => 't.isActive="Y" AND ( event_title LIKE "%' . $seacrh_term . '%" OR description LIKE "%' . $seacrh_term . '%")', 'order' => 'event_end_time'));

                if (!empty($resource))
                    $resources = Resource::model()->findAll(array('condition' => 't.isActive="Y" AND ( resource_title LIKE "%' . $seacrh_term . '%" OR description LIKE "%' . $seacrh_term . '%")', 'order' => 'id'));

                $heading = "Search Results : \"" . $arr_data['seacrh_term'] . "\"";
                $this->render('search_results', array(
                    'products' => $products,
                    'events' => $events,
                    'resources' => $resources,
                    'heading' => $heading,
                    'seacrh_term' => $seacrh_term));
            }
        } else {
            $this->render('404');
        }
    }

    public function actionGetProducts() {

        /* $arr_data   = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
          $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING); */ //PHP 5

        $arr_data = filter_input_array(INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        //if(count($arr_data) > 0){ //PHP 5
        if ($arr_data !== null) {

            $category_id = (int) $arr_data['category_id'];
            $sub_category_id = (int) $arr_data['sub_category_id'];
            $product_category_id = (int) $arr_data['product_category_id'];
            $product_sub_category_id = (int) $arr_data['product_sub_category_id'];

            $condition = 't.isActive="Y" AND ( t.category_id=' . $category_id . ' OR productMapping.category_id=' . $category_id . ')';
            if ($sub_category_id > 0)
                $condition .= ' AND ( t.sub_category_id=' . $sub_category_id . ' OR productMapping.sub_category_id=' . $sub_category_id . ')';
            if ($product_category_id > 0)
                $condition .= ' AND (t.product_category_id=' . $product_category_id . ' OR  productMapping.product_category_id=' . $product_category_id . ')';
            if ($product_sub_category_id > 0)
                $condition .= ' AND (t.product_sub_category_id=' . $product_sub_category_id . ' OR productMapping.product_sub_category_id=' . $product_sub_category_id . ')';

            $products = Product::model()->with('productMapping')->together(true)->findAll(array('condition' => $condition, 'order' => 'product_name DESC'));

            $product_array = array();
            $subcatftrs = "";
            $k = 0;
            $z = 0;

            if (isset($_POST['checklist'])) {
                foreach ($_POST['checklist'] as $i => $each) {

                    if (empty($each)) {

                    } else {

                        $k = 1;
                        $count = count($_POST['checklist']);

                        $subcatftrs .= 'OR t.product_sub_category_feature_id IN(';

                        foreach ($each as $j => $eachsub) {
                            if ($j == 0) {
                                $subcatftrs .= $eachsub;
                            } else {
                                $subcatftrs .= "," . $eachsub;
                            }
                        }

                        $subcatftrs .= ')  AND (ptp_product.sub_category_id=' . $sub_category_id . ' OR ptp_product_mapping.sub_category_id=' . $sub_category_id . ') ';
                        $z++;
                    }
                    // print_r($each);
                }
            }
            $subcatftrs = substr_replace($subcatftrs, '', 0, 2);
            $subcatftrs = ltrim($subcatftrs, ",");
            // echo $k."%%%%%%%%%%%".$subcatftrs;
            if ($subcatftrs != "")
                $subcatftrsarray = explode(',', $subcatftrs);
            else
                $subcatftrsarray = array();
            //  print_r($subcatftrsarray);
            $count = sizeof($subcatftrsarray);
            //  echo $count; die("dd");
            // $sql = "select product_id from ptp_product_filter_feature where product_sub_category_feature_id in(" . $subcatftrs . ") group by product_id having count(*)>=" . $count;
            //$products=Yii::app()->db->createCommand($sql)->queryAll();
            //   echo $subcatftrs;die("ff");
            // print_r($productsnewArray);
            // die();
            /*             * ***** checking whether these productss in that particular category,subcategory....  ************* */
            if ($k == 1) {
                $SQL = "Select t.product_id as id,ptp_product.id as pid,ptp_product_mapping.product_id as mid from ptp_product_filter_feature as t LEFT JOIN ptp_product ON ptp_product.id=t.product_id LEFT JOIN ptp_product_mapping ON ptp_product_mapping.product_id=t.product_id where $subcatftrs AND (ptp_product.category_id=" . $category_id . " OR ptp_product_mapping.category_id=" . $category_id . ")  group by t.product_id having count(t.product_id) >= $z order by ptp_product.product_name DESC";
//            echo $SQL;
                $result = Yii::app()->db->createCommand($SQL)->queryAll();
//            $criteria=new CDbCriteria;
////            $criteria->with = array('product');
////            $criteria->select = array('id,product_sub_category_feature_id,product_id,product_name');
//            $criteria->join='INNER JOIN ptp_product ON ptp_product.id=t.product_id';
//            $criteria->addInCondition('t.product_sub_category_feature_id',$subcatftrsarray);
//            $criteria->group = 'product_id';
//            $criteria->order='product_name DESC';
//            $pro=ProductFilterFeature::model()->findAll($criteria);
////            $pro=ProductFilterFeature::model()->with('product')->findAll(array('condition' => 't.product_sub_category_feature_id in(' . $subcatftrs . ')','order'=>'product.product_name DESC'));
//            $products = CHtml::listData($pro, 'product_id', 'product_id');
//            $productsnewArray = array_values($products);
//            $result = array_intersect($newArray, $productsnewArray);
            } else {
                $condition = 't.isActive="Y" AND ( t.category_id=' . $category_id . ' OR productMapping.category_id=' . $category_id . ')';
                if ($sub_category_id > 0)
                    $condition .= ' AND ( t.sub_category_id=' . $sub_category_id . ' OR productMapping.sub_category_id=' . $sub_category_id . ')';
                if ($product_category_id > 0)
                    $condition .= ' AND (t.product_category_id=' . $product_category_id . ' OR  productMapping.product_category_id=' . $product_category_id . ')';
                if ($product_sub_category_id > 0)
                    $condition .= ' AND (t.product_sub_category_id=' . $product_sub_category_id . ' OR productMapping.product_sub_category_id=' . $product_sub_category_id . ')';

                $products = Product::model()->with('productMapping')->together(true)->findAll(array('condition' => $condition, 'order' => 'product_name DESC'));
                $result = $products;
            }

            $jsonData['products'] = "<ul>";
            $baseurl = Yii::app()->request->baseUrl;
            if (!empty($result)) {
                foreach ($result as $eachresult) {

                    if ($k == 1) {
                        if ($eachresult['pid'] != '') {
                            $p = $eachresult['pid'];
                        }
                        $product = Product::model()->findbypk((int) $p);
                    } else {
                        $product = Product::model()->findbypk((int) $eachresult->id);
                    }
                    $enc_string = $product->id;
                    $product_details = Yii::app()->controller->encryptCipherDecrypt($enc_string, 'e');
                    $jsonData['products'] .= '<li class="col"><a href="' . $baseurl . '/index.php/product/details?det=' . $product_details . '">
                   <b style="height: 109px; position: relative;">';

                    $p_image = ProductImages::model()->find(array('condition' => 'product_id=' . $product->id . ' AND main_image=1'));

                    if (!empty($p_image)) {
                        $jsonData['products'] .= '<img max-width:100% src="' . $baseurl . '/images/product/' . $p_image->product_image . '" alt="" class="product-image" ></b>
                                            <strong>';
                    } else {
                        $jsonData['products'] .= '<img max-width:100% src="' . $baseurl . '/images/product/' . $product->product_image . '" alt="" class="product-image" ></b>
                                            <strong>';
                    }
                    if (strlen($product->product_generic_name) > 50) {
                        $jsonData['products'] .= substr($product->product_generic_name, 0, 50) . "..";
                    } else {
                        $jsonData['products'] .= $product->product_generic_name;
                    }

                    $jsonData['products'] .= '</strong><em>
                                            ' . $product->product_name . '

                                            </em></a>
                                        <b class="status-icon id-151"> </b>
                                    </li> ';
                }
            }
            $jsonData['products'] .= "<ul>";

            // $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $this->render('404');
        }
        ///////////////////////////////////////////
    }

    public function actionGetProducts1() {

        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        $sub_category_id = (int) $_POST['sub_category_id'];
        $product_category_id = (int) $_POST['product_category_id'];
        $product_sub_category_id = (int) $_POST['product_sub_category_id'];
        $condition = 't.isActive="Y"';
        if ($sub_category_id > 0)
            $condition .= ' AND ( t.sub_category_id=' . $sub_category_id . ' OR productMapping.sub_category_id=' . $sub_category_id . ')';
        if ($product_category_id > 0)
            $condition .= ' AND (t.product_category_id=' . $product_category_id . ' OR  productMapping.product_category_id=' . $product_category_id . ')';
        if ($product_sub_category_id > 0)
            $condition .= ' AND (t.product_sub_category_id=' . $product_sub_category_id . ' OR productMapping.product_sub_category_id=' . $product_sub_category_id . ')';

        $products = Product::model()->with('productMapping')->together(true)->findAll(array('condition' => $condition, 'order' => 'product_name DESC'));
        // print_r($array);
//        $newArray = array_values($array);
        //   print_r($newArray);
//die("ddddd");
        $product_array = array();
        $subcatftrs = "";
        $k = 0;
        $z = 0;
        foreach ($_POST['checklist'] as $i => $each) {

            if (empty($each)) {

            } else {

                $k = 1;
                $count = count($_POST['checklist']);

                $subcatftrs .= 'OR t.product_sub_category_feature_id IN(';

                //  die("hellloooooooooooooooooooooooooo");
                foreach ($each as $j => $eachsub) {
                    if ($j == 0) {
                        $subcatftrs .= $eachsub;
                    } else {
                        $subcatftrs .= "," . $eachsub;
                    }
                }
                $subcatftrs .= ') ';
                $z++;
            }
            // print_r($each);
        }
        $subcatftrs = substr_replace($subcatftrs, '', 0, 2);
        $subcatftrs = ltrim($subcatftrs, ",");
        // echo $k."%%%%%%%%%%%".$subcatftrs;
        if ($subcatftrs != "")
            $subcatftrsarray = explode(',', $subcatftrs);
        else
            $subcatftrsarray = array();
        //  print_r($subcatftrsarray);
        $count = sizeof($subcatftrsarray);
        //  echo $count; die("dd");
        // $sql = "select product_id from ptp_product_filter_feature where product_sub_category_feature_id in(" . $subcatftrs . ") group by product_id having count(*)>=" . $count;
        //$products=Yii::app()->db->createCommand($sql)->queryAll();
        //   echo $subcatftrs;die("ff");
        // print_r($productsnewArray);
        // die();
        /*         * ***** checking whether these productss in that particular category,subcategory....  ************* */
        if ($k == 1) {
            $SQL = "Select * from ptp_product_filter_feature as t INNER JOIN ptp_product ON ptp_product.id=t.product_id where $subcatftrs group by t.product_id having count(t.product_id) >= $z order by ptp_product.product_name DESC";
//            echo $SQL;
            $result = Yii::app()->db->createCommand($SQL)->queryAll();
//            $criteria=new CDbCriteria;
////            $criteria->with = array('product');
////            $criteria->select = array('id,product_sub_category_feature_id,product_id,product_name');
//            $criteria->join='INNER JOIN ptp_product ON ptp_product.id=t.product_id';
//            $criteria->addInCondition('t.product_sub_category_feature_id',$subcatftrsarray);
//            $criteria->group = 'product_id';
//            $criteria->order='product_name DESC';
//            $pro=ProductFilterFeature::model()->findAll($criteria);
////            $pro=ProductFilterFeature::model()->with('product')->findAll(array('condition' => 't.product_sub_category_feature_id in(' . $subcatftrs . ')','order'=>'product.product_name DESC'));
//            $products = CHtml::listData($pro, 'product_id', 'product_id');
//            $productsnewArray = array_values($products);
//            $result = array_intersect($newArray, $productsnewArray);
        } else {
            $condition = 't.isActive="Y"';
            if ($sub_category_id > 0)
                $condition .= ' AND ( t.sub_category_id=' . $sub_category_id . ' OR productMapping.sub_category_id=' . $sub_category_id . ')';
            if ($product_category_id > 0)
                $condition .= ' AND (t.product_category_id=' . $product_category_id . ' OR  productMapping.product_category_id=' . $product_category_id . ')';
            if ($product_sub_category_id > 0)
                $condition .= ' AND (t.product_sub_category_id=' . $product_sub_category_id . ' OR productMapping.product_sub_category_id=' . $product_sub_category_id . ')';

            $products = Product::model()->with('productMapping')->together(true)->findAll(array('condition' => $condition, 'order' => 'product_name DESC'));
            $result = $products;
        }

        $jsonData['products'] = "<ul>";
        $baseurl = Yii::app()->request->baseUrl;
        foreach ($result as $eachresult) {
            if ($k == 1) {
                $product = Product::model()->findbypk((int) $eachresult['id']);
            } else {
                $product = Product::model()->findbypk((int) $eachresult->id);
            }
            $enc_string = $product->id;
            $product_details = Yii::app()->controller->encryptCipherDecrypt($enc_string, 'e');
            $jsonData['products'] .= '<li class="col"><a href="' . $baseurl . '/index.php/product/details?det=' . $product_details . '">
                   <b style="height: 109px; position: relative;">';
            $p_image = ProductImages::model()->find(array('condition' => 'product_id=' . $product->id . ' AND main_image=1'));
            if (!empty($p_image)) {
                $jsonData['products'] .= '<img max-width:100% src="' . $baseurl . '/images/product/' . $p_image->product_image . '" alt="" class="product-image" ></b>
                                            <strong>';
            } else {
                $jsonData['products'] .= '<img max-width:100% src="' . $baseurl . '/images/product/' . $product->product_image . '" alt="" class="product-image" ></b>
                                            <strong>';
            }
            if (strlen($product->product_generic_name) > 40) {
                $jsonData['products'] .= substr($product->product_generic_name, 0, 40) . "..";
            } else {
                $jsonData['products'] .= substr($product->product_generic_name, 0, 40);
            }

            $jsonData['products'] .= '</strong>
                                            ' . $product->product_name . '

                                            </em></a>
                                        <b class="status-icon id-151"> </b>
                                    </li> ';
        }
        $jsonData['products'] .= "<ul>";

        // $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
        ///////////////////////////////////////////
    }

    public function actionSupportResource() {
        ini_set('memory_limit', '-1');
        $product_id = 0;
        $downloadbles = array();
        $model = new Support();
        // $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING); //php 5
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        $status = "";
        if (isset($_POST['Support']) && isset($_POST['YII_CSRF_TOKEN']) && $_POST['YII_CSRF_TOKEN'] === Yii::app()->request->csrfToken) {

            $model->attributes = $_POST['Support'];

            if ($model->validate()) {
                if ($_POST['radio'] == "login")
                    $this->redirect(Yii::app()->baseUrl . '/../support/index.php/site/login?HfGty=' . base64_encode(json_encode($model->attributes)) . '#tologin');
                else
                    $this->redirect(Yii::app()->baseUrl . '/../support/index.php/site/login?HfGty=' . base64_encode(json_encode($model->attributes)) . '#toregister');
            }
        }
        if (isset($_POST['product_name']) && isset($_POST['YII_CSRF_TOKEN']) && $_POST['YII_CSRF_TOKEN'] === Yii::app()->request->csrfToken) {

            $captcha = "";
            if (isset($_POST['g-recaptcha-response'])) {
                $captcha = $_POST['g-recaptcha-response'];
            }

            if (!$captcha) {
                $status = 'Please choose captcha';
            } else {

                $google_secret_key = "6Lfg2yQTAAAAAE_vZSob16lhM-McyXeEJYArMnla";
                $response = json_decode(file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=" . $google_secret_key . "&response=" . $captcha . "&remoteip=" . $_SERVER['REMOTE_ADDR']), true);

                if ($response['success'] == false) {
                    $status = 'You are a spammer';

                    //echo '<h2>You are spammer ! Get the @$%K out</h2>';
                } else {



                    $product_id = $_POST['product_name'];
                    $modelProductDownloadableRelation = ProductDownloadableRelation::model()->with('downloadable')->findAll(array('condition' => 'product_id=' . $product_id));

                    $modelProductDownloadable = ProductDownloadable::model()->findAll(array('condition' => 'isActive="Y"'));

                    $downloadbles = array();
                    foreach ($modelProductDownloadableRelation as $eachProductsd) {
                        foreach ($modelProductDownloadable as $eachDownloadable) {
                            if ($eachProductsd->item_id == $eachDownloadable->id) {
                                $downloadbles[$eachDownloadable->id]['item_value'][] = $eachProductsd->item_value;
                                $downloadbles[$eachDownloadable->id]['files_available'][] = $eachProductsd->files_available;
                                $downloadbles[$eachDownloadable->id]['downloadbal_title'] = $eachDownloadable->item_name;
                            }
                        }
                    }

                    if (count($downloadbles) == 0) {
                        $status = 'No Data Sheet Available';
                    }
                }
            }
        }
        /* if ($_GET['pid']) {

          $modelProductDownloadableRelation = ProductDownloadableRelation::model()->with('downloadable')->findAll(array('condition' => 'product_id=' . $_GET['pid']));

          $modelProductDownloadable = ProductDownloadable::model()->findAll(array('condition' => 'isActive="Y"'));
          $downloadbles = array();
          foreach ($modelProductDownloadableRelation as $eachProductsd) {
          foreach ($modelProductDownloadable as $eachDownloadable) {
          if ($eachProductsd->item_id == $eachDownloadable->id) {
          $downloadbles[$eachDownloadable->id]['item_value'][] = $eachProductsd->item_value;
          $downloadbles[$eachDownloadable->id]['files_available'][] = $eachProductsd->files_available;
          $downloadbles[$eachDownloadable->id]['downloadbal_title'] = $eachDownloadable->item_name;
          }
          }
          }
          } */
        $this->render('pages/support_resource', array('model' => $model, 'downloadbles' => $downloadbles, 'status' => $status, 'product_id' => $product_id));
    }

    public function actionSupportEticket() {
        ini_set('memory_limit', '-1');
        $model = new Support;
        $downloadbles = array();
        //$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING); //php 5

        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        if (isset($_POST['Support']) && isset($_POST['YII_CSRF_TOKEN']) && $_POST['YII_CSRF_TOKEN'] === Yii::app()->request->csrfToken) {

            if (isset($_POST['g-recaptcha-response'])) {
                $captcha = $_POST['g-recaptcha-response'];
            }
            if (!$captcha) {
                $jsonData['status'] = 'nocaptcha';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            } else {

                $google_secret_key = "6LdbijoUAAAAAEAJL6pPiQBuuzgMQMeQOr7DiQF2";
                $response = json_decode(file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=" . $google_secret_key . "&response=" . $captcha . "&remoteip=" . $_SERVER['REMOTE_ADDR']), true);
                if ($response['success'] == false) {
                    $jsonData['status'] = 'spammer';
                    echo CJSON::encode($jsonData);
                    Yii::app()->end();
                } else {

                    $model->attributes = $_POST['Support'];
                    $model->model_no_service = $_POST['model_no_service'];

                    //if ($model->validate()) {
                    if ($_POST['radio'] == "login")
                        $this->redirect(Yii::app()->baseUrl . '/support/index.php/site/login?HfGty=' . base64_encode(json_encode($model->attributes)) . '#tologin');
                    else
                        $this->redirect(Yii::app()->baseUrl . '/support/index.php/site/login?HfGty=' . base64_encode(json_encode($model->attributes)) . '#toregister');
                    // }
                }
            }
        }
        $id = isset($_GET['pid']) ? $_GET['pid'] : "";
        if ($id > 0) {

            $modelProductDownloadableRelation = ProductDownloadableRelation::model()->with('downloadable')->findAll(array('condition' => 'product_id=' . $id));

            $modelProductDownloadable = ProductDownloadable::model()->findAll(array('condition' => 'isActive="Y"'));
            $downloadbles = array();
            foreach ($modelProductDownloadableRelation as $eachProductsd) {
                foreach ($modelProductDownloadable as $eachDownloadable) {
                    if ($eachProductsd->item_id == $eachDownloadable->id) {
                        $downloadbles[$eachDownloadable->id]['item_value'][] = $eachProductsd->item_value;
                        $downloadbles[$eachDownloadable->id]['files_available'][] = $eachProductsd->files_available;
                        $downloadbles[$eachDownloadable->id]['downloadbal_title'] = $eachDownloadable->item_name;
                    }
                }
            }
        }
        $this->render('pages/support_eticket', array('model' => $model, 'downloadbles' => $downloadbles));
    }

    public function actionCategoryMain() {

        //added by abin on 23-11-20230to decrypt the main id
        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        if ($arr_data !== null) {
            $enc_string = $arr_data['main'];
        }
        $decrypted_string = Yii::app()->controller->encryptCipherDecrypt($enc_string, 'd');
        //echo $decrypted_string;
        $id = (int) $decrypted_string;
        //end of
        //$id=(int)Yii::app()->request->getParam('main');
        $criteria = new CDbCriteria();
        $criteria->condition = 't.isActive = :isActive AND t.main_category_id = :main';
        $criteria->order = 'maincategory.sort_order,subcategory.sort_order';
        $criteria->params = array(':isActive' => 'Y', ':main' => $id);
        $item_count = Product::model()->with('maincategory', 'category', 'subcategory')->count($criteria);

        $pages = new CPagination($item_count);
        $pages->setPageSize(/* Yii::app()->params['listPerPage'] */24);
        $pages->applyLimit($criteria);  // the trick is here!

        $this->render('category_products', array(
            //'model' => Product::model()->findAll($criteria), // must be the same as $item_count
            'model' => Product::model()->with('maincategory', 'category', 'subcategory')->findAll($criteria), // must be the same as $item_count
            'item_count' => $item_count,
            'page_size' => /* Yii::app()->params['listPerPage'] */24,
            'items_count' => $item_count,
            'pages' => $pages,
        ));
    }

    public function actionSubCategory() {
        //added by abin on 23-11-20230to decrypt the cat id
        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        if ($arr_data !== null) {
            $enc_string = $arr_data['cat'];
        }
        $decrypted_string = Yii::app()->controller->encryptCipherDecrypt($enc_string, 'd');
        //echo $decrypted_string;
        $id = (int) $decrypted_string;
        //end of code


        $criteria = new CDbCriteria();
        $criteria->condition = 't.isActive = :isActive AND t.category_id = :main';
        $criteria->order = 'maincategory.sort_order,subcategory.sort_order';
        $criteria->params = array(':isActive' => 'Y', ':main' => $id);
        $item_count = Product::model()->with('maincategory', 'category', 'subcategory')->count($criteria);

        $pages = new CPagination($item_count);
        $pages->setPageSize(/* Yii::app()->params['listPerPage'] */24);
        $pages->applyLimit($criteria);  // the trick is here!

        $this->render('category_products', array(
            //'model' => Product::model()->findAll($criteria), // must be the same as $item_count
            'model' => Product::model()->with('maincategory', 'category', 'subcategory')->findAll($criteria), // must be the same as $item_count
            'item_count' => $item_count,
            'page_size' => /* Yii::app()->params['listPerPage'] */24,
            'items_count' => $item_count,
            'pages' => $pages,
        ));
    }

    public function actionArticleDetails() {
//        $this->layout =null;
        $arr_data = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);

        if (count($arr_data) > 0) {
            $id = (int) $arr_data['id'];
            $model = News::model()->findbyPK($id);
            $this->render('article_details', array(
                'model' => $model,
            ));
        } else {
            $this->render('404');
        }
    }

    public function action404() {
        $this->render('404');
    }

}
