<?php

class UsertypesController extends Controller {

    public $title = "User";

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'SaveUserTypes', 'DeleteUsers',
                    'SalesMaster', 'GetSalesList', 'Target', 'SaveTarget', 'UploadSignature',
                    'BlockUser', 'UnBlockUser', 'changepassword', 'Updatepassword',
                    'ChangeMypassword','Viewprofile','SaveProfile','LogoUpload','ProfilePhotoUpload'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
       // if (isset(Yii::app()->user->havePermissionOn['user']) || isset(Yii::app()->user->havePermissionOn['admin_user_view']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        //     } else {
        //      throw new CHttpException(401, 'Unauthorized Access');
        // }
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new UserType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'type',
           
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = " 1=1 ";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
          //  $condition .= " and (fullname LIKE '%" . $searchString . "%' OR user_full_name LIKE '%" . $searchString . "%' OR userGroup.group_name LIKE '%" . $searchString . "%')";
        
         $condition .= "  (type LIKE '%" . $searchString . "%' )";     
            
        }
       // $count = $model->with('userGroup')->count(array('condition' => $condition));
      //  $model = $model->with('userGroup')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'fullname'));
        
         $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
             //if (((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'usertypes/create&id=' . $row['id'] . '\',\'User Type\',\'lg\')"><i class="fas fa-edit"></i></button>';
            // }
           
                
           
            $rowData[] = array($m,
                $row['type'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['type'])
            );

            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new UserType();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('user_type_form', array('model' => $model), false, false);
    }

    public function actionSaveUserTypes() {
        $model = new UserType();
        if (isset($_POST['UserType'])) {
            if ((int) @$_POST['UserType']['id'] > 0) {

                $id = (int) @$_POST['UserType']['id'];
                $model = $model->findByPk($id);
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['UserType'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
