<?php

class UsergroupController extends Controller {

    public $title = 'User Group';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'create', 'SaveUserGroup', 'DeleteUserGroup'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
         if (isset(Yii::app()->user->havePermissionOn['user_group']) || isset(Yii::app()->user->havePermissionOn['admin_usergroup_view']) || Yii::app()->user->authorised_user == 1) {
            $models = MasUserGroup::model()->findAll();
            $this->render('index', array('model' => $model), false, true);
        } else {
             throw new CHttpException(401, 'Unauthorized Access');
        }
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new MasUserGroup;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('usergroup_form', array('model' => $model));
    }

    public function actionGetlist() {
        $model = new MasUserGroup;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'group_name',
            1 => 'group_name',
            2 => 'group_name',
            3 => 'name',
            4 => 'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.id != 1 ';
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition .= " AND ( group_name LIKE '%" . $searchString . "%' OR id LIKE '%" . $searchString . "%' )";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowgrp = "Edit User Group";
        $rowData = array();

        foreach ($model as $i => $row) {
            $div = '';
             if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["user_group"]) || isset(Yii::app()->user->havePermissionOn['admin_usergroup_edit']) ) {
            $div = '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'usergroup/create&id=' . $row['id'] . '\',\'' . $rowgrp . '\',\'xl\')"><i class="fa fa-tasks"></i></button>';
             }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["user_group"]) || isset(Yii::app()->user->havePermissionOn['admin_usergroup_delete']) ) {
            $div .= '&nbsp; <button class="btn btn-danger btn-xs" title ="Delete" onclick="deleteUserGroup(' . $row['id'] . ')"><i class="fa fa-trash"></i></button>';
             }
            // $div .= '&nbsp;<button class="btn btn-primary btn-xs" title ="add" onclick="loadPopupModal(\'mastax/CreateMasUserGroupTransaction&meeting_id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['type'] . '\',\'md\')"><i class="fa  fa-exchange"></i></button>';

            $rowData[] = array(($i + 1), $row["group_name"], '<div class="btn-wrap text-center">' . $div . '</div>');
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSave() {
        if (isset($_POST)) {
            date_default_timezone_set("Asia/Dubai");
            $model = new MasUserGroup;
            if ((int) $_POST['MasUserGroup']['id'] > 0) {
                $model = $model->findByPk($_POST['MasUserGroup']['id']);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d H:i:s');
            $model->attributes = $_POST['MasUserGroup'];
            if ($model->validate()) {
                echo json_encode(array('status' => 'success'));
                $model->save();
            } else {
                echo CActiveForm::validate($model, '', false);
            }
        }
    }

    public function actionSaveUserGroup() {
        $model = new MasUserGroup();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['MasUserGroup'])) {

            if ((int) @$_POST['MasUserGroup']['id'] > 0) {

                $model->id = (int) $_POST['MasUserGroup']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->group_name = $_POST['MasUserGroup']['group_name'];
            $model->attributes = $_POST['MasUserGroup'];
            $allPermissions = array();
            foreach ($_POST['MasUserGroup']['permissions'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->permissions = json_encode($allPermissions);
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteUserGroup() {
        $id = $_POST['id'];
        $model = new MasUserGroup();
        $pro = $model->findByPk($id); // audit log changes
        $model->deleteByPk($id);

        echo "success";
    }

}
