<?php

class MaincategoryController extends Controller {

    public $title = "Main Category";

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'Save', 'DeleteCategory',
                    'BlockMainCategory', 'UnBlockMainCategory', 'changepassword', 'Updatepassword',
                 ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
       // if (isset(Yii::app()->MainCategory->havePermissionOn['user']) || isset(Yii::app()->user->havePermissionOn['admin_user_view']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        //     } else {
        //      throw new CHttpException(401, 'Unauthorized Access');
        // }
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MainCategory();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'main_category',
            2 => 'id'
         );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (main_category LIKE '%" . $searchString . "%'  )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'maincategory/create&id=' . $row['id'] . '\',\'Main Category\',\'sm\')"><i class="fas fa-edit"></i></button>';
             // }
           //  if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_delete"]) || isset(Yii::app()->user->havePermissionOn['admin_user_delete'])) {
                // if ($row->isActive == 'Y') {
                //     $div .= ' <a href ="#" class="btn btn-success btn-xs" onclick="disablecategory(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                // }
                // if ($row->isActive == 'N') {
                //     $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="enablecategory(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                // }
            // }
            $rowData[] = array(
                $m,
                $row['main_category'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['main_category'])
            );

            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MainCategory();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new MainCategory();
        if (isset($_POST['MainCategory'])) {
            if ((int) @$_POST['MainCategory']['id'] > 0) {

                $id = (int) @$_POST['MainCategory']['id'];
                $model = $model->findByPk($id);
             } else {
                 $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MainCategory'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionBlockMainCategory() {
        $id = $_POST['id'];
        if ($id > 0) {
            MainCategory::model()->updateByPK($id, array('isActive' => "N"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockMainCategory() {
        $id = $_POST['id'];
        if ($id > 0) {
            MainCategory::model()->updateByPK($id, array('isActive' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

     
}
