<?php

/**
 * Controller is the customized base controller class.
 * All controller classes for this application should extend from this base class.
 */
class Controller extends CController {

    public $layout = 'layout';
    public $menu = array();
    public $breadcrumbs = array();
    public $numberFormat = array('decimals' => 2, 'decimalSeparator' => ',', 'thousandSeparator' => '');

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'TableRo', 'Forgotpassword', 'Recover', 'Country', 'UpdateProductGroup', 'UpdateProductCategory',
                    'UpdateProductType', 'UpdateProduct'),
                'users' => array('*'),
            ),
        );
    }
    
    public function init() {
            parent::init();
            $this->initAjaxCsrfToken();
    }
	
	
      
    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

            Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                             data: {"' . Yii::app()->request->csrfTokenName . '": "' . Yii::app()->request->csrfToken . '"},
                             cache:false
                        });', CClientScript::POS_HEAD);
        }
        
        
        /* public function beforeAction($action) {


        if (Yii::app()->request->isAjaxRequest)

            $this->layout = false;

        return parent::beforeAction($action);

    }*/
    
    
    
    public function beforeAction($action) {
        if (Yii::app()->request->isAjaxRequest)
            $this->layout = false;
        return parent::beforeAction($action);
    }

    /**
     * Displays the login page
     */
    public function actionLogin() {
        if (Yii::app()->user->isGuest) {
            if (!Yii::app()->request->isAjaxRequest)
                $this->layout = "login";
            $model = new LoginForm;

            // if it is ajax validation request
            if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
                echo CActiveForm::validate($model);
                Yii::app()->end();
            }

            // collect user input data
            if (isset($_POST['LoginForm'])) {
                $model->attributes = $_POST['LoginForm'];
                // validate user input and redirect to the previous page if valid
                if ($model->validate() && $model->login()) {
                    if (!Yii::app()->request->isAjaxRequest)
                        $this->redirect(Yii::app()->user->returnUrl);
                    else {
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                    }
                } else {
                    if (!Yii::app()->request->isAjaxRequest)
                        $this->redirect(array('site/login'));
                    else {
                        $jsonData['status'] = 'error';
                        echo CJSON::encode($jsonData);
                    }
                }
            } else {
                // display the login form
                if (!Yii::app()->request->isAjaxRequest)
                    $this->render('login', array('model' => $model));
                else {
                    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
                    $this->renderPartial('login', array('model' => $model), false, true);
                }
            }
        } else {
            if (!Yii::app()->request->isAjaxRequest)
                $this->redirect(array('site/index'));
            else {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }
    
   /* public function beforeAction($action)
    {
    	$request_uri 		= $_SERVER['REQUEST_URI'];
        $len_request_uri 	= strlen($request_uri);
        $constant_length = 100;
        if(Yii::app()->controller->id=='user'){
            if ((UserType::model()->findByPk( User::model()->findByPK(Yii::app()->user->id)->user_type_id )->type) != 'administrator' && (UserType::model()->findByPk( User::model()->findByPK(Yii::app()->user->id)->user_type_id )->type)!='superadmin')
            {
                    echo Yii::app()->user->id.(UserType::model()->findByPk( Yii::app()->user->id )->type).'HTTP Error 401 Unauthorized! You dont have privilages to see the content | '.CHtml::link('Home',"administrator.php");
                    die();
            }
            return true;

        }
        else if (isset(Yii::app()->user->id) && Yii::app()->user->id > 0) {
                return parent::beforeAction($action);
        }
        else{
            if (parent::beforeAction($action)) {
    		
                    
                    $arr_str_len = parse_url($request_uri);
                    $arr_path_info = explode("/",$arr_str_len['path']);
                    
                    
                    if(isset($arr_path_info[2]) && $arr_path_info[2]=='news'){
                    	$constant_length = 150;
                    }
                   


                    //echo $_SERVER['REQUEST_URI'];
                    //echo $len_request_uri;
                    if($len_request_uri > $constant_length){
                            $this->render('../site/404');
                            return false;
                    }
                    
                }
    		
    		return true;
    	}
    	return false;
    }*/

    /*public function actionLogin() {
        $model = new LoginForm;

        if (!Yii::app()->request->isAjaxRequest)
            $this->layout = "loginlayout";

        //if it is ajax validation request
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        // collect user input data
        if (isset($_POST['LoginForm']) && $_POST['YII_CSRF_TOKEN'] === Yii::app()->request->csrfToken) {
            $model->attributes = $_POST['LoginForm'];
            // validate user input and redirect to the previous page if valid
            if ($model->validate() && $model->login())
                $this->redirect(Yii::app()->user->returnUrl);
        }
        // display the login form
        $this->render('login', array('model' => $model));
    }*/

    public function actionLogout() {
        Yii::app()->user->logout();
        $this->redirect(Yii::app()->homeUrl);
    }

    public function downloadFile($file, $folder) {
        //die("here");
        $filename = Yii::app()->getBaseUrl(true) . $folder . $file;
        //$file_url = 'http://www.myremoteserver.com/' . $file_name;
        header('Content-Type: application/octet-stream');
        header("Content-Transfer-Encoding: Binary");
        header("Content-disposition: attachment; filename=\"" . $file . "\"");
        readfile($filename);
    }

    /* public function actionLogin() {
      if (Yii::app()->user->isGuest) {
      if (!Yii::app()->request->isAjaxRequest)
      $this->layout = "loginlayout";
      $model = new LoginForm;

      // if it is ajax validation request
      if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
      echo CActiveForm::validate($model);
      Yii::app()->end();
      }

      // collect user input data
      if (isset($_POST['LoginForm'])) {
      $model->attributes = $_POST['LoginForm'];
      // validate user input and redirect to the previous page if valid
      if ($model->validate() && $model->login()) {
      if (!Yii::app()->request->isAjaxRequest)
      $this->redirect(Yii::app()->user->returnUrl);
      else {
      $jsonData['status'] = 'success';
      echo CJSON::encode($jsonData);
      }
      } else {
      if (!Yii::app()->request->isAjaxRequest)
      $this->redirect(array('site/login'));
      else {
      echo "hi";
      $jsonData['status'] = 'error';
      echo CJSON::encode($jsonData);
      }
      }
      } else {
      // display the login form
      if (!Yii::app()->request->isAjaxRequest)
      $this->render('login', array('model' => $model));
      else {
      Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
      $this->renderPartial('login', array('model' => $model), false, true);
      }
      }
      } else {
      if (!Yii::app()->request->isAjaxRequest)
      $this->redirect(array('site/index'));
      else {
      $jsonData['status'] = 'success';
      echo CJSON::encode($jsonData);
      }
      }
      } */

    public function actionUpload($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $field_id = "";
        if (isset($_GET['field_id'])) {
            $field_id = Yii::app()->request->getParam('field_id');
        }


        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
// make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
//chmod($folder, 0755);
        }
        $allowedExtensions = array("jpg","jpeg","gif","exe","mov","pdf","doc","png","zip","bin","hid","tar","rar"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 700 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename']; //GETTING FILE NAME

        if ($folder == 'upload/product') {
            $imagename = Yii::app()->basePath . '/../upload/product/' . $fileName;
            $imagename_thumb = Yii::app()->basePath . '/../upload/product/thumbs/' . $fileName;
            $imagename_resized = Yii::app()->basePath . '/../upload/product/image_resized/' . $fileName;
            Yii::import("ext.EPhpThumb.EPhpThumb");

            $thumb = new EPhpThumb();
            $thumb->init(); //this is needed
            //chain functions
            $thumb->create($imagename)->resize(500, 350)->save($imagename_resized);
            $thumb->create($imagename)->resize(300, 300)->save($imagename_thumb);
        }
        echo $return; // it's array
    }

    public function actionUpload1($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
// make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
//chmod($folder, 0755);
        }
        $allowedExtensions = array("jpg", "jpeg", "gif", "png", "pdf", "doc", "docx", "xls", "csv","zip","bin","hid","tar","rar"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 700 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename']; //GETTING FILE NAME
        // print_r($fileName);die();
        // $this->CropIfImage($folder, $fileName, 100, 100);
        echo $return; // it's array
    }

    public function actionUpload2($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
// make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
//chmod($folder, 0755);
        }
        $allowedExtensions = array("jpg", "jpeg", "gif", "png", "pdf", "doc", "docx", "xls", "csv","zip","bin","hid","tar","rar"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 700 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename'];
        echo $return; // it's array
    }

    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo $error['message'];
            } else {
                $this->render('error', $error);
            }
        }
    }

    public function actionUpdateProductGroup() {
        $data = ProductGroup::model()->findAll('user_group_id=:parent_id', array(':parent_id' => (int) $_POST['user_group_id']));

        $data = CHtml::listData($data, 'id', 'product_group_name');
        echo CHtml::tag('option', array('value' => ''), 'Select group', true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function actionUpdateProductCategory() {
        $data = ProductCategory::model()->findAll('user_group_id=:parent_id AND product_group_id=:parent_id1', array(
            ':parent_id' => (int) $_POST['user_group_id'],
            ':parent_id1' => (int) $_POST['product_group_id']
                )
        );

        $data = CHtml::listData($data, 'id', 'category_name');
        echo CHtml::tag('option', array('value' => '0'), 'No category', true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function actionUpdateProductType() {
        $data = ProductType::model()->findAll('user_group_id=:parent_id AND product_group_id=:parent_id1 AND category_id=:parent_id2', array(
            ':parent_id' => (int) $_POST['user_group_id'],
            ':parent_id1' => (int) $_POST['product_group_id'],
            ':parent_id2' => (int) $_POST['product_category_id']
                )
        );

        $data = CHtml::listData($data, 'id', 'type_name');
        echo CHtml::tag('option', array('value' => '0'), 'No Type', true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function actionUpdateProduct() {
        $data = Product::model()->findAll('user_group_id=:parent_id and product_group_id=:parent_id1 and product_category_id=:parent_id2', array(
            ':parent_id' => (int) $_POST['user_group_id'],
            ':parent_id1' => (int) $_POST['product_group_id'],
            ':parent_id2' => (int) $_POST['product_category_id'],
                )
        );

        $data = CHtml::listData($data, 'id', 'product_name');
        echo CHtml::tag('option', array('value' => ''), 'Select product', true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function actionAjaxupdate() {
        $act = $_GET['act'];

        if ($act == 'doChangeStatus') {
            $model = $this->loadModel($_POST['autoId']);
            $model->isActive = ($model->isActive == 'Y') ? 'N' : 'Y';
            $model->save(false);
            $img = ($model->isActive == 'Y') ? 'active.png' : 'inactive.png';
            echo CHtml::image("images/admin/" . $img, "");
        } else if ($act == 'doSortOrder') {
            $sortOrderAll = $_POST['sortOrder'];
            if (count($sortOrderAll) > 0) {
                foreach ($sortOrderAll as $menuId => $sortOrder) {
                    $model = $this->loadModel($menuId);
                    $model->sortOrder = $sortOrder;
                    $model->save(false);
                }
            }
        } else {
            $autoIdAll = $_POST['autoId'];
            if (count($autoIdAll) > 0) {
                foreach ($autoIdAll as $autoId) {
                    $model = $this->loadModel($autoId);
                    if ($act == 'doDelete')
                        $model->is_delete = 'Y';
                    if ($act == 'doActive')
                        $model->is_active = 'Y';
                    if ($act == 'doInactive')
                        $model->is_active = 'N';
                    if ($model->save(false))
                        echo 'ok';
                    else
                        throw new Exception("Sorry", 500);
                }
            }
        }
    }
    
    public function encryptCipherDecrypt( $string, $action) {
    	$secret_key = "@#123&^!";
    	$secret_iv = "lamp@1983#dc";
    	$output = false;
    	$encrypt_method = "AES-256-CBC";
    	$key = hash( 'sha256', $secret_key );
    	$iv = substr( hash( 'sha256', $secret_iv ), 0, 16 );
    
    	if( $action == 'e' ) {
    		$output = base64_encode( openssl_encrypt( $string, $encrypt_method, $key, 0, $iv ) );
    	}
    	else if( $action == 'd' ){
    		$output = openssl_decrypt( base64_decode( $string ), $encrypt_method, $key, 0, $iv );
    	}
    
    	return $output;
    }

}
