<?php
/* @var $this SiteController */
/* @var $model LoginForm */
/* @var $form CActiveForm  */

$this->pageTitle=Yii::app()->name . ' - Login';
$this->breadcrumbs=array(
	'Login',
);
?>

<h1>Login using following social sites</h1>
<?php $this->widget('application.modules.hybridauth.widgets.renderProviders'); ?>
<p> Or Please fill out the following form with your login credentials:</p>

<div class="form">
<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'login-form',
	'enableClientValidation'=>true,
	'clientOptions'=>array(
		'validateOnSubmit'=>true,
	),
)); ?>

	<p class="note">Fields with <span class="required">*</span> are required.</p>

	<div class="row">
		<?php echo $form->labelEx($model,'username'); ?>
		<?php echo $form->textField($model,'username'); ?>
		<?php echo $form->error($model,'username'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'password'); ?>
		<?php echo $form->passwordField($model,'password'); ?>
		<?php echo $form->error($model,'password'); ?>
		<p class="hint">
			Hint: You may login with <kbd>demo</kbd>/<kbd>demo</kbd> or <kbd>admin</kbd>/<kbd>admin</kbd>.
		</p>
	</div>

	<div class="row rememberMe">
		<?php echo $form->checkBox($model,'rememberMe'); ?>
		<?php echo $form->label($model,'rememberMe'); ?>
		<?php echo $form->error($model,'rememberMe'); ?>
	</div>

	<div class="row buttons">
		<?php echo CHtml::submitButton('Login'); ?>
	</div>

<?php $this->endWidget(); ?>
</div><!-- form -->

<?php	echo CHtml::link('Signup Without Social sites', '#', array('onclick'=>'$("#signup").dialog("open"); return false;',)); ?>
<?php	$this->beginWidget('zii.widgets.jui.CJuiDialog', array(
    	'id'=>'signup',
    	// additional javascript options for the dialog plugin
    	'options'=>array(
        	'title'=>'Dialog box 1',
        	'autoOpen'=>false,
    	),
		));
?>
<?php 	$this->renderPartial('form', array('user' => $model,));?>
<?php 	$this->endWidget('zii.widgets.jui.CJuiDialog'); ?>
</div>