<?php
/* @var $this CaseStudyController */
/* @var $model Paper */
/* @var $form CActiveForm */
?>

<div id="communicationsbox" style="height:525px; background-color:#f7eee1;">
<?php
    foreach(Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
?>

  <div id="form_wrapper">
<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'paper-form',
	'enableAjaxValidation'=>false,
	'htmlOptions' => array(
        'enctype' => 'multipart/form-data',
    ),
)); ?>

	<p class="note">Fields with <span class="required">*</span> are required.</p>

	<?php echo $form->errorSummary($model); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'user_id'); ?>
		<?php echo $form->dropDownList($model,'user_id',User::getAllusers(null,'Y',true)); ?>
		<?php echo $form->error($model,'user_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'title_of_the_paper'); ?>
		<?php echo $form->textField($model,'title_of_the_paper',array('size'=>60,'maxlength'=>255)); ?>
		<?php echo $form->error($model,'title_of_the_paper'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'region_id'); ?>
		<?php  echo $form->dropDownList($model,'region_id',Country::getCountry(),array('prompt'=>'Select country')); ?>
		<?php echo $form->error($model,'region_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'user_group_id'); ?>
		<?php echo $form->dropDownList($model,'user_group_id',UserGroup::getGroups(),
											 array(
												'style'=>'width:150px',
												'prompt'=>'Select user group',
												'ajax' => array(
												'type'=>'POST',
												'url'=>CController::createUrl('Product/updateProductGroup'), 
												//'update'=>'#Product_product_group_id',
												'data'=>array('user_group_id'=>'js:this.value'), 
												'success'=>'js:function(data){
													$("#Paper_product_group_id").html(data)
													$("#Paper_product_category_id").html("<option value=\"\">Select category</option>")
													$("#Paper_product_id").html("<option value=\"\">Select product</option>")
													}'
            ))); ?>
		<?php echo $form->error($model,'user_group_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'product_group_id'); ?>
		<?php echo $form->dropDownList($model,'product_group_id',ProductGroup::getProductGroup($model->user_group_id),array(
												'style'=>'width:150px',
												'prompt'=>'Select group',
												'ajax' => array(
												'type'=>'POST',
												'url'=>CController::createUrl('Product/updateProductCategory'), 
												'data'=>array(
															  'user_group_id'=>'js:$("#Paper_user_group_id :selected").val()',  
															  'product_group_id'=>'js:this.value'
															  ),  
												'success'=>'js:function(data){
													$("#Paper_product_category_id").html(data)
													$("#Paper_product_id").html("<option value=\"\">Select product</option>")
													}'
																		  ))); ?> 
		<?php echo $form->error($model,'product_group_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'product_category_id'); ?>
		<?php  echo $form->dropDownList($model,'product_category_id',ProductCategory::getProductCategory($model->user_group_id,$model->product_group_id),array(
												'style'=>'width:150px',
												'prompt'=>'Select category',
												'ajax' => array(
												'type'=>'POST',
												'url'=>CController::createUrl('Product/updateProduct'), 
												'update'=>'#Paper_product_id',
												'data'=>array(
															  'user_group_id'=>'js:$("#Paper_user_group_id :selected").val()',  
															  'product_group_id'=>'js:$("#Paper_product_group_id :selected").val()',  
															  'product_category_id'=>'js:this.value'
															  ),  
																		  ))); ?>
		<?php echo $form->error($model,'product_category_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'product_id'); ?>
        <?php echo $form->dropDownList($model,'product_id',Product::getProduct($model->user_group_id,$model->product_group_id,$model->product_category_id),array('style'=>'width:150px', 'prompt'=>'Select product',)); ?>
		<?php echo $form->error($model,'product_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'industry_id'); ?>
        <?php echo $form->dropDownList($model,'industry_id',Industry::getIndustry(),array('style'=>'width:150px', 'prompt'=>'Select industry',)); ?>
		<?php echo $form->error($model,'industry_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'year'); ?>
        <?php for($i=date('Y');$i>=1990;$i--) $years[$i]=$i; ?>
        <?php echo $form->dropDownList($model,'year',$years,array('style'=>'width:150px', 'prompt'=>'Select year',)); ?>
		<?php echo $form->error($model,'year'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'filename'); ?>
		<?php echo $form->fileField($model,'filename'); ?>
		<?php echo $form->error($model,'filename'); ?>
		<?php if(!$model->isNewRecord): ?>
        <?php echo CHtml::link($model->filename,Yii::app()->baseUrl.'/media/paper/'.$model->filename); ?>
        <?php endif; ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'content'); ?>
		<?php echo $form->textArea($model,'content',array('class'=>'ckeditor','cols'=>"80",'rows'=>"10")); ?>
		<?php echo $form->error($model,'content'); ?>
	</div>
    
    <?php if(!$model->isNewRecord) : ?>
	<div class="row">
		<?php echo $form->labelEx($model,'isActive'); ?>
        <?php echo $form->dropDownList($model,'isActive',array('Y'=>'Active','N'=>'Inactive'),array('style'=>'width:150px', 'prompt'=>'Select',)); ?>
		<?php echo $form->error($model,'isActive'); ?>
	</div>
    <?php endif; ?>
    
	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Submit' : 'Save'); ?>
	</div>

<?php $this->endWidget(); ?>

</div><!-- form -->
</div>