<?php
/* @var $this TrainingToolsController */
/* @var $model TrainingTools */
/* @var $form CActiveForm */
?>

<div id="communicationsbox" style="height:525px; background-color:#f7eee1;">
<?php
    foreach(Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
?>

  <div id="form_wrapper">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'training-tools-form',
	'enableAjaxValidation'=>false,
    'htmlOptions' => array(
        'enctype' => 'multipart/form-data',
        ),
)); ?>

	<div id="row">
  <fieldset id="current">
    <legend><strong>Training Tools</strong></legend>
    <br />
    <table width="800" border="0" cellspacing="0" cellpadding="5">
        <tr>
        <td><?php echo $form->labelEx($model,'title'); ?></td>
        <td>
		
		<?php echo $form->textField($model,'title',array('size'=>60,'maxlength'=>255)); ?>
		<?php echo $form->error($model,'title'); ?>
	</td>
      </tr>
      
      <tr>
        <td><?php echo $form->labelEx($model,'content'); ?></td>
        <td>
                <?php echo $form->textArea($model,'content',array('rows'=>6, 'cols'=>50)); ?>
		<?php echo $form->error($model,'content'); ?>
	</td>
      </tr>
      
      <tr>
        <td><?php echo $form->labelEx($model,'isLink'); ?></td>
        <td>
                <?php echo $form->dropDownList($model,'isLink',array('Y'=>'Yes','N'=>'No'),array()); ?>
		<?php echo $form->error($model,'isLink'); ?>
	</td>
      </tr>
      
      <tr class="file_upload" <?php if($model->isLink=="Y"): ?> style="display: none;" <?php endif; ?>>
        <td><?php echo $form->labelEx($model,'File *'); ?></td>
        <td>
            <?php if(!$model->isNewRecord): ?>
            <?php echo CHtml::link($model->file,"media/trainingtools/".$model->file); ?>
            <?php endif; ?>
                <?php $this->widget('CMultiFileUpload',array(
                    'model'=>$model,
                    'attribute'=>'file',
                    'name'=>'file',
                    //'accept'=>'pdf|jpg|png|jpeg|zip|ppt|pptx|doc|docx|txt|mpg|wma|avi|dat',
                    'max'=>1,
                    'remove'=>Yii::t('ui','Remove'),
                    //'denied'=>'This is not a supported file(Please choose jpg,jpeg,png or gif)', //message that is displayed when a file type is not allowed
                    'duplicate'=>'file appears twice', //message that is displayed when a file appears twice
                    'htmlOptions'=>array('size'=>25),
                )); ?>
                <?php echo $form->hiddenField($model,'file'); ?>
		<?php echo $form->error($model,'file'); ?>
	</td>
      </tr>
      
      <tr class="href" <?php if($model->isLink=="N"): ?> style="display: none;" <?php endif; ?>>
        <td><?php echo $form->labelEx($model,'href'); ?></td>
        <td>
                <?php echo $form->textField($model,'href',array('size'=>60,'maxlength'=>255)); ?>
		<?php echo $form->error($model,'href'); ?>
	</td>
      </tr>
      
      <tr>
        <td><?php echo $form->labelEx($model,'image_name'); ?></td>
        <td>
            <?php if(!$model->isNewRecord): ?>
            <?php echo CHtml::image("media/trainingtools/thumbs/120_150".$model->image_name, "loading.."); ?>
            <?php endif; ?>
              <?php $this->widget('CMultiFileUpload',array(
                    'model'=>$model,
                    'attribute'=>'image_name',
                    'name'=>'image_name',
                    'accept'=>'pdf|jpg|png|jpeg',
                    'max'=>1,
                    'remove'=>Yii::t('ui','Remove'),
                    'denied'=>'This is not an image file(Please choose jpg,jpeg,png or gif)', //message that is displayed when a file type is not allowed
                    'duplicate'=>'file appears twice', //message that is displayed when a file appears twice
                    'htmlOptions'=>array('size'=>25),
                )); ?>
                <?php echo $form->hiddenField($model,'image_name'); ?>
		<?php echo $form->error($model,'image_name'); ?>
	</td>
      </tr>
      
      <tr>
        <td><?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?></td>
        <td>
               
	</td>
      </tr>
      </table>
  </fieldset>
</div>

<?php $this->endWidget(); ?>

</div><!-- form -->
</div><!-- form -->

<?php
$cs = Yii::app()->getClientScript();  
$cs->registerScript(
  'file_or_link',
  "$('#TrainingTools_isLink').change(function()
      {    
      var selecetd_choice =   $(this).val();    
      if(selecetd_choice=='N')    
      {        
      $('.file_upload').show();        
      $('.href').hide();    
      }    
      else    
      {        
      $('.href').show();        
      $('.file_upload').hide();    
      }
      });",
  CClientScript::POS_END
);
?>