<?php

/**
 * This is the model class for table "{{_video_center}}".
 *
 * The followings are the available columns in table '{{_video_center}}':
 * @property string $id
 * @property string $user_group_id
 * @property string $purpose
 * @property string $target_user
 * @property string $title
 * @property string $brief_description
 * @property string $date
 * @property string $video_script
 * @property string $isActive
 */
class VideoCenter extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VideoCenter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_video_center}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_group_id, product_id', 'length', 'max'=>20),
                        array('title, date, video_script', 'required'),
			array('purpose, target_user, title, date, video_script', 'length', 'max'=>255),
			array('brief_description', 'length', 'max'=>1000),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_group_id, purpose, target_user, title, brief_description, date, video_script, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
                     'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
		);
                
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_group_id' => 'Category',
                        'product_id'=>'Product',
			'purpose' => 'Purpose',
			'target_user' => 'Target User',
			'title' => 'Title',
			'brief_description' => 'Brief Description',
			'date' => 'Date',
			'video_script' => 'Youtube Video url',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
                
		$criteria->compare('id',$this->id,true);
		$criteria->compare('user_group_id',$this->user_group_id,true);
		$criteria->compare('purpose',$this->purpose,true);
		$criteria->compare('target_user',$this->target_user,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('brief_description',$this->brief_description,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('video_script',$this->video_script,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}