<?php

class ProductSubCategoryController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = 'product';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
            'postOnly + delete', // we only allow deletion via POST request
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            /* array('allow', // allow all users to perform 'index' and 'view' actions
              'actions' => array('login', 'error', 'logout', 'test', 'recover'),
              'users' => array('*'),
              ), */
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'index', 'changeStatus', 'ajaxupdate', 'view', 'Upload', 'admin', 'delete', 'Loadcategory', 'Loadsubcategory', 'Loadproductcategory'),
                'expression' => '$user->isAdmin()'
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new ProductSubCategory;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['ProductSubCategory'])) {
            $model->attributes = $_POST['ProductSubCategory'];
            $model->description=$_POST['ProductSubCategory']['description'];
            if ($model->save())
                $this->redirect(array('index'));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        $category = Category::model()->findAll('main_category_id=:c_id', array(':c_id' => (int) $model->main_category_id));
        $category = CHtml::listData($category, 'id', 'category');
        $subcategory = SubCategory::model()->findAll('category_id=:c_id', array(':c_id' => (int) $model->category_id));
        $subcategory = CHtml::listData($subcategory, 'id', 'sub_category');
        $productcategory = ProductCategory::model()->findAll('sub_category_id=:c_id', array(':c_id' => (int) $model->sub_category_id));
        //print_r($productcategory);die("dd");
        $productcategory = CHtml::listData($productcategory, 'id', 'product_category');
        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['ProductSubCategory'])) {
        	
        	$new_sort_order  = 0;
        	if(!empty($_POST['ProductSubCategory']['product_category_id']))
        	{
        		$SQL = "SELECT MAX(sort_order) AS max_sort_order FROM ptp_product_sub_category WHERE product_category_id=".$_POST['ProductSubCategory']['product_category_id'];
        		$arr_sort_order = Yii::app()->db->createCommand($SQL)->queryAll();
        		$max_sort_order = $arr_sort_order[0]['max_sort_order'];
        		 
        		$new_sort_order = $max_sort_order+1;
        	}
        	 
        	 
            $model->attributes = $_POST['ProductSubCategory'];
            $model->sort_order = $new_sort_order;
            $model->description=$_POST['ProductSubCategory']['description'];
            if ($model->save())
                $this->redirect(array('index'));
        }

        $this->render('create', array(
            'model' => $model,
            'category'=>$category,
            'subcategory'=>$subcategory,
            'productcategory'=>$productcategory,
            
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        $this->loadModel($id)->delete();

        // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
        if (!isset($_GET['ajax']))
            $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $model = new ProductSubCategory('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductSubCategory']))
            $model->attributes = $_GET['ProductSubCategory'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new ProductSubCategory('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductSubCategory']))
            $model->attributes = $_GET['ProductSubCategory'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer $id the ID of the model to be loaded
     * @return ProductSubCategory the loaded model
     * @throws CHttpException
     */
    public function loadModel($id) {
        $model = ProductSubCategory::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param ProductSubCategory $model the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'product-sub-category-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionLoadcategory() {
        $data = Category::model()->findAll('main_category_id=:c_id', array(':c_id' => (int) $_POST['main_category_id']));
        $data = CHtml::listData($data, 'id', 'category');
        echo CHtml::tag('option', array('value' => ""), CHtml::encode("select"), true);
        foreach ($data as $value => $name)
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
    }

    public function actionLoadsubcategory() {
        $data = SubCategory::model()->findAll('category_id=:c_id', array(':c_id' => (int) $_POST['category_id']));
        $data = CHtml::listData($data, 'id', 'sub_category');
        echo CHtml::tag('option', array('value' => ""), CHtml::encode("select"), true);
        foreach ($data as $value => $name)
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
    }

    public function actionLoadproductcategory() {
        $data = ProductCategory::model()->findAll('sub_category_id=:c_id', array(':c_id' => (int) $_POST['sub_category_id']));
        $data = CHtml::listData($data, 'id', 'product_category');
        echo CHtml::tag('option', array('value' => ""), CHtml::encode("select"), true);
        foreach ($data as $value => $name)
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
    }

}
