<?php

class ProductResourceController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='resource';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','create','update','admin','delete','ajaxupdate','updateProductGroup','updateProductCategory','updateProduct',
				),				
				'expression'=>'$user->isAdmin()'
				),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new ProductResource;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
                if(count($_POST) > 0 && isset($_POST['ProductResource']))
		{
			$rnd = rand(0,9999);  // generate random number between 0-9999
			$model->attributes=$_POST['ProductResource'];
			
			$uploadedFile=CUploadedFile::getInstance($model,'source_file');
			if(!empty($uploadedFile))  // check if uploaded file is set or not
            {
				$fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
				$model->source_file = $fileName;
			}			if($model->save())			
				{			
				if(!empty($uploadedFile))
					{
						$uploadedFile->saveAs(Yii::app()->basePath.'/../media/resources/'.$fileName);  // image will uplode to rootDirectory/banner/
					}					$this->redirect(array('index'));
				}		}		$this->render('create',array(			'model'=>$model,		));	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
                if(count($_POST) > 0 && isset($_POST['ProductResource']))
		{
			
			if(($temp=$model->source_file)!='')

			{

				$_POST['ProductResource']['source_file'] = $model->source_file; 

			}

			

			$model->attributes=$_POST['ProductResource'];

			

			$uploadedFile=CUploadedFile::getInstance($model,'source_file');

			

			if($temp=='' && !empty($uploadedFile))  

            {

				$rnd = rand(0,9999);

				$fileName = "{$rnd}-{$uploadedFile}";  // random number + file name

				$model->source_file = $fileName;

			}
			
			if($model->save())
			{
				
				if(!empty($uploadedFile))  // check if uploaded file is set or not

                {

					$uploadedFile->saveAs(Yii::app()->basePath.'/../media/resources/'.$model->source_file);

                }
				$this->redirect(array('index'));
			}
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Manages all models.
	 */
	public function actionIndex()
	{
		$model=new ProductResource('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['ProductResource']))
			$model->attributes=$_GET['ProductResource'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=ProductResource::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='resource-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
