<?php

class CategoryController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	  public $layout='product';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}
        

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	 function accessRules()
	{
		 return array(
            /* array('allow', // allow all users to perform 'index' and 'view' actions
              'actions' => array('login', 'error', 'logout', 'test', 'recover'),
           public   'users' => array('*'),
              ), */
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'index','changeStatus', 'ajaxupdate', 'view', 'Upload', 'admin', 'delete'),
                'expression' => '$user->isAdmin()'
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}


	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	/* public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Category']))
		{
			$model->attributes=$_POST['Category'];
			if($model->save())
				$this->redirect(array('index'));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	} */

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            $subcategory = SubCategory::model()->count('category_id=:ID', array(':ID' => $id));
            $productcategory = ProductCategory::model()->count('category_id=:ID', array(':ID' => $id));
            $productsubcategory = ProductSubCategory::model()->count('category_id=:ID', array(':ID' => $id));
            //$files=File::model()->findAll(array('condition'=>'category_id=:x', 'params'=>array(':x'=>$id)));
            if (($subcategory == 0) && ($productcategory == 0) && ($productsubcategory == 0)) {
                $this->loadModel($id)->delete();
    
                // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
                if (!isset($_GET['ajax']))
                    $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
            }
            else {
                //throw new CHttpException(400, Yii::t('app', 'Deletion not possible.'));
                //echo '<script> alert("Deletion not possible");</script>';
                echo "fail";
            }
        }
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$model=new Category('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Category']))
			$model->attributes=$_GET['Category'];
		
		//Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('admin',array(
			'model'=>$model,
		), false, true);
	}
	
	public function actionCreate()
	{
		$model=new Category;
	
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		
		$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['Category'])){
			$rnd = rand(0,9999);  // generate random number between 0-9999
			$model->attributes=$_POST['Category'];
				
			$uploadedFile=CUploadedFile::getInstance($model,'icon_image');
				
			if(!empty($uploadedFile))  // check if uploaded file is set or not
			{
				$fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
				$model->icon_image = $fileName;
			}
				
			if($model->save())
			{
				if(!empty($uploadedFile))
				{
					$uploadedFile->saveAs(Yii::app()->basePath.'/../images/usergroup/'.$fileName);  // image will uplode to rootDirectory/banner/
				}
				$this->redirect(array('index'));
			}
		}
	
		$this->render('create',array(
				'model'=>$model,
		));
	}
	
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
	
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
	
		$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['Category']))
		{
			if(($temp=$model->icon_image)!='')
			{
				$_POST['Category']['icon_image'] = $model->icon_image;
			}
				
			$model->attributes=$_POST['Category'];
				
			$uploadedFile=CUploadedFile::getInstance($model,'icon_image');
				
			if($temp=='' && !empty($uploadedFile))
			{
				$rnd = rand(0,9999);
				$fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
				$model->icon_image = $fileName;
			}
			if($model->save())
			{
				if(!empty($uploadedFile))  // check if uploaded file is set or not
				{
					$uploadedFile->saveAs(Yii::app()->basePath.'/../images/usergroup/'.$fileName);
				}
				$this->redirect(array('index'));
			}
		}
	
		$this->render('update',array(
				'model'=>$model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Category('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Category']))
			$model->attributes=$_GET['Category'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Category the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Category::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Category $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='category-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
