<?php
class Treeview 
{

    // built specifically for silver stripe tree menu
    public function buildmenu($parent_id,$action='site/page')
    {
        // get the nodes array starting with the parent one
        $menu_array = $this->get_menu_nodes($parent_id);
        $html='';
		if(is_array($menu_array))
        foreach ($menu_array as $menu)
        {
            if ($this->hasChildren($menu['id']))
            {
				if($menu['isLink']	== "Y")
					$link = $menu['href'];
				else
					$link	=	Yii::app()->createUrl($action,array('id'=>$menu['id'],'name'=>preg_replace('/[^a-z0-9_]/','',strtolower( str_replace(" ", "_", $menu['menu_title'])))));
                $html.="<li><a href=\"".$link."\" class=\"documents\">".$menu['menu_title'] . "</a><ul>";
                $childarray = $menu['children'];
                foreach ( $childarray as $child)
                {
					if($menu['isLink']	== "Y")
						$link = $menu['href'];
					else
						$link	=	Yii::app()->createUrl($action,array('id'=>$child['id'],'name'=>preg_replace('/[^a-z0-9_]/','',strtolower( str_replace(" ", "_", $child['menu_title'])))));
                    $html.="<li><a href=\"".$link."\" class=\"documents\">".$child['menu_title'] . "</a></li>";
                }
                $html.= "</ul></li>";
            
            } else {
				if($menu['isLink']	== "Y")
						$link = $menu['href'];
				else
					$link	=Yii::app()->createUrl($action,array('id'=>$menu['id'],'name'=>preg_replace('/[^a-z0-9_]/','',strtolower( str_replace(" ", "_", $menu['menu_title'])))));	
                $html.="<li><a href=\"".$link."\" class=\"documents\">".$menu['menu_title'] . "</a></li>";
            }
            
        }
        
        return $html;
    }
    
    //starts the gathering the section's parent nodes
    //starts the gathering the section's parent nodes
    function get_menu_nodes($parent_id)
    {
        // just get top level nodes initially
        $condition = 'isActive="Y" AND parent_id = '.$parent_id;
        $result = $this->build_menu_array($condition);
        return $result;
    }
    //the recursive menu 'engine'
    function build_menu_array($condition)
    {
		$node_array='';
        $result = MenuItem::model()->findAll(array('condition'=>$condition,'order'=>'sortOrder desc'));
   		foreach ($result as $row)
        {
            $node_items = array();
            $node_items['id'] = $row->id;
            $node_items['menu_title'] = $row->menu_title;  
			$node_items['isLink'] = $row->isLink; 
			$node_items['href'] = $row->href; 
            
            // if the node has children get them now - recursive
            // store in in children array
           if ($this->hasChildren($row->id))
           {   
               $children = $this->get_menu_nodes($row->id);           
               $node_items['children'] = $children;           
           } else {
               $node_items['children'] = '';
           }
           $node_array[] = $node_items;
        }                  
        return $node_array;
    }

    function hasChildren($id)
    {
        $bool = FALSE;
		$results = MenuItem::model()->count(array('condition'=>'isActive="Y" AND parent_id='.$id));
        if ($results>0) $bool = TRUE;
        return $bool;
    }
}
?>