<?php

/**
 * This is the model class for table "{{user_profile}}".
 *
 * The followings are the available columns in table '{{user_profile}}':
 * @property string $user_id
 * @property string $country_birth
 * @property string $current_address
 * @property string $permanent_address
 * @property string $country_residence
 * @property string $bank_account_details
 * @property string $nationality_birth
 * @property string $nationality_current
 * @property string $date_of_birth
 * @property string $languages_spoken
 * @property string $picture
 * @property string $profile_video_id
 * @property string $biography
 * @property string $twitter_link
 * @property string $facebook_link
 * @property string $website
 * @property string $awards
 * @property string $film_festivals
 * @property string $email_address_secondary
 * @property string $is_active
 *
 * The followings are the available model relations:
 * @property Country $nationalityCurrent
 * @property User $user
 * @property Country $countryBirth
 * @property Country $countryResidence
 */
class UserProfile extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserProfile the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{user_profile}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_birth, current_address, permanent_address, country_residence, bank_account_details, nationality_birth, nationality_current, languages_spoken, picture, profile_video_id, biography, twitter_link, facebook_link, website, awards, film_festivals, email_address_secondary', 'required'),
			array('country_birth, country_residence, nationality_birth', 'length', 'max'=>5),
			array('current_address, permanent_address, bank_account_details, nationality_current, languages_spoken, picture, twitter_link, facebook_link, website, email_address_secondary', 'length', 'max'=>255),
			array('date_of_birth', 'length', 'max'=>15),
			array('profile_video_id', 'length', 'max'=>20),
			array('is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_id, country_birth, current_address, permanent_address, country_residence, bank_account_details, nationality_birth, nationality_current, languages_spoken, picture, profile_video_id, biography, twitter_link, facebook_link, website, awards, film_festivals, email_address_secondary, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'nationalityCurrent' => array(self::BELONGS_TO, 'Country', 'nationality_current'),
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
			'countryBirth' => array(self::BELONGS_TO, 'Country', 'country_birth'),
			'countryResidence' => array(self::BELONGS_TO, 'Country', 'country_residence'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_id' => 'User',
			'country_birth' => 'Country Birth',
			'current_address' => 'Current Address',
			'permanent_address' => 'Permanent Address',
			'country_residence' => 'Country Residence',
			'bank_account_details' => 'Bank Account Details',
			'nationality_birth' => 'Nationality Birth',
			'nationality_current' => 'Nationality Current',
			'languages_spoken' => 'Languages Spoken',
			'picture' => 'Picture',
			'profile_video_id' => 'Profile Video',
			'biography' => 'Biography',
			'twitter_link' => 'Twitter Link',
			'facebook_link' => 'Facebook Link',
			'website' => 'Website',
			'awards' => 'Awards',
			'film_festivals' => 'Film Festivals',
			'email_address_secondary' => 'Email Address Secondary',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('country_birth',$this->country_birth,true);
		$criteria->compare('current_address',$this->current_address,true);
		$criteria->compare('permanent_address',$this->permanent_address,true);
		$criteria->compare('country_residence',$this->country_residence,true);
		$criteria->compare('bank_account_details',$this->bank_account_details,true);
		$criteria->compare('nationality_birth',$this->nationality_birth,true);
		$criteria->compare('nationality_current',$this->nationality_current,true);
		$criteria->compare('languages_spoken',$this->languages_spoken,true);
		$criteria->compare('picture',$this->picture,true);
		$criteria->compare('profile_video_id',$this->profile_video_id,true);
		$criteria->compare('biography',$this->biography,true);
		$criteria->compare('twitter_link',$this->twitter_link,true);
		$criteria->compare('facebook_link',$this->facebook_link,true);
		$criteria->compare('website',$this->website,true);
		$criteria->compare('awards',$this->awards,true);
		$criteria->compare('film_festivals',$this->film_festivals,true);
		$criteria->compare('email_address_secondary',$this->email_address_secondary,true);
		$criteria->compare('is_active',$this->is_active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
}