<?php

/**
 * This is the model class for table "{{_downloadable}}".
 *
 * The followings are the available columns in table '{{_downloadable}}':
 * @property string $id
 * @property string $product_id
 * @property string $item_id
 * @property string $item_value
 * @property string $files_available
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property Product $product
 */
class ProductDownloadableRelation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Downloadable the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_downloadable_realation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('product_id, item_id, item_value, files_available', 'required'),
			array('product_id, item_id', 'length', 'max'=>20),
			array('item_value', 'length', 'max'=>255),
			array('files_available', 'file', 'allowEmpty'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, product_id, item_id, item_value, files_available, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'downloadable' => array(self::BELONGS_TO, 'ProductDownloadable', 'item_id'),
			'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'item_id' => 'Item',
			'item_value' => 'Item Value',
			'files_available' => 'Files Available',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('product_id',$this->product_id,true);
		$criteria->compare('item_id',$this->item_id,true);
		$criteria->compare('item_value',$this->item_value,true);
		$criteria->compare('files_available',$this->files_available,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
}
