<?php

/**
 * This is the model class for table "{{_certification}}".
 *
 * The followings are the available columns in table '{{_certification}}':
 * @property integer $id
 * @property string $certification_name
 * @property string $rewardPoints
 */
class Certification extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Certification the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_certification}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('certification_name, rewardPoints', 'required'),
            array('certification_name', 'length', 'max' => 255),
            array('rewardPoints', 'length', 'max' => 50),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, certification_name, rewardPoints', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'certification_name' => 'Certification Name',
            'rewardPoints' => 'Points',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('certification_name', $this->certification_name, true);
        $criteria->compare('rewardPoints', $this->rewardPoints, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getCertifications() {
        $condition = '1=1';
        $model = self::model()->findAll(array('condition' => $condition, /*'order' => 'certification_name'*/));
        return CHtml::listData($model, 'id', 'certification_name');
    }

}