<?php

/**
 * This is the model class for table "{{_resource}}".
 *
 * The followings are the available columns in table '{{_resource}}':
 * @property integer $id
 * @property integer $resource_type_id
 * @property string $resource_title
 * @property string $source_file
 * @property string $description
 * @property string $user_group_id
 * @property string $product_group_id
 * @property string $product_category_id
 * @property string $product_id
 * @property integer $isActive
 *
 * The followings are the available model relations:
 * @property ResourceType $resourceType
 * @property UserGroup $userGroup
 * @property ProductGroup $productGroup
 * @property ProductCategory $productCategory
 * @property Product $product
 */
class Resource extends CActiveRecord
{
	public $resourceType_search_resource_type;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Resource the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_resource}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('resource_type_id, resource_title, source_file, description, user_group_id, product_group_id, product_category_id', 'required'),
			array('resource_type_id', 'numerical', 'integerOnly'=>true),
			array('resource_title', 'length', 'max'=>255),
			array('source_file', 'file','types'=>'jpg, jpeg, gif, png, doc, zip, docx, txt, pdf, zip', 'allowEmpty'=>true, 'on'=>'update'),
			array('user_group_id, product_group_id, product_category_id, product_id', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, resource_type_id, resource_title, source_file, description, user_group_id, product_group_id, product_category_id, product_id, isActive, resourceType_search_resource_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'resourceType' => array(self::BELONGS_TO, 'ResourceType', 'resource_type_id'),
			'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
			'productGroup' => array(self::BELONGS_TO, 'ProductGroup', 'product_group_id'),
			'productCategory' => array(self::BELONGS_TO, 'ProductCategory', 'product_category_id'),
			'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'resource_type_id' => 'Resource Type',
			'resource_title' => 'Resource Title',
			'source_file' => 'Source File',
			'description' => 'Description',
			'user_group_id' => 'User Group',
			'product_group_id' => 'Product Group',
			'product_category_id' => 'Product Category',
			'product_id' => 'Product',
			'resourceType_search_resource_type'=>'Resource Type',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->with = array('resourceType');
		$criteria->compare('id',$this->id);
		$criteria->compare('resource_type_id',$this->resource_type_id);
		$criteria->compare('resource_title',$this->resource_title,true);
		$criteria->compare('source_file',$this->source_file,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('user_group_id',$this->user_group_id);
		$criteria->compare('product_group_id',$this->product_group_id);
		$criteria->compare('product_category_id',$this->product_category_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('isActive',$this->isActive);
		
		$criteria->compare('resourceType.resource_type',$this->resourceType_search_resource_type,true);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize']),
			'sort'=>array(
				'defaultOrder'=>'t.id DESC',
        		'attributes'=>array(
            		'resourceType_search_resource_type'=>array(
                		'asc'=>'resourceType.resource_type',
                		'desc'=>'resourceType.resource_type DESC',
            		),
           			'*',
       			),
    		),
		));
	}
}
