<?php

/**
 * This is the model class for table "{{_product_mapping}}".
 *
 * The followings are the available columns in table '{{_product_mapping}}':
 * @property string $product_id
 * @property string $user_group_id
 * @property string $product_group_id
 * @property string $category_id
 * @property string $type_id
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property ProductType $type
 * @property Product $product
 * @property UserGroup $userGroup
 * @property ProductGroup $productGroup
 * @property ProductCategory $category
 */
class ProductMapping extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductMapping the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_mapping}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('product_id, user_group_id, product_group_id, category_id, type_id', 'required'),
			array('product_id, user_group_id, product_group_id, category_id, type_id', 'length', 'max'=>20),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('product_id, user_group_id, product_group_id, category_id, type_id, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'type' => array(self::BELONGS_TO, 'ProductType', 'type_id'),
			'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
			'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
			'productGroup' => array(self::BELONGS_TO, 'ProductGroup', 'product_group_id'),
			'category' => array(self::BELONGS_TO, 'ProductCategory', 'category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'product_id' => 'Product',
			'user_group_id' => 'User Group',
			'product_group_id' => 'Product Group',
			'category_id' => 'Category',
			'type_id' => 'Type',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('product_id',$this->product_id,true);
		$criteria->compare('user_group_id',$this->user_group_id,true);
		$criteria->compare('product_group_id',$this->product_group_id,true);
		$criteria->compare('category_id',$this->category_id,true);
		$criteria->compare('type_id',$this->type_id,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}