<?php

class DigitalLibraryController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='resource';
        
        public function actions()
        {
            return array(
                'captcha'=>array(
                    'class'=>'CCaptchaAction',
                    'backColor'=>0xFFFFFF,
                ),
                'page'=>array(
                    'class'=>'CViewAction',
                ),
                'coco'=>array(
                    'class'=>'CocoAction',
                ),
            );
        }
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','create','update','admin','delete','ajaxupdate','updateProductGroup','updateProductCategory','updateProduct',
				),				
				'expression'=>'$user->isAdmin()'
				),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new DownloadCentre;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['DownloadCentre'])){
			//$model->attributes=$_POST['DownloadCentre'];
                        $files = CUploadedFile::getInstancesByName('files');
                        $user_group_id  =   $_POST['DownloadCentre']['user_group_id'];
                        foreach ($files as $key=>$eachFile)
                        {
                            $fileName = md5(microtime().rand()).'_'.$eachFile->name;
                            $eachFile->saveAs(Yii::app()->basePath.'/../media/downloadcenter/'.$fileName);
                            
                            //thumb section
                            $thumb=Yii::app()->phpThumb->create('media/downloadcenter/'.$fileName);
                            $thumb->resize(120,90);
                            $thumb->save('media/downloadcenter/thumbs/120_150'.$fileName);
                            //thumb section
                            
                                
                            $model=new DownloadCentre;
                            $model->file    =  $fileName; 
                            $temp  =  explode('.',$eachFile->name);
                            $model->file_title =    $temp[0];
                            $model->file_type =    strtoupper($temp[1]);
                            $model->type    =   "dl";
                            $model->user_group_id    =  $user_group_id; 
                            $model->save();
                        }
                        $this->redirect(array('index'));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['DownloadCentre'])){
			$model->attributes=$_POST['DownloadCentre'];
                        $files   =    CUploadedFile::getInstancesByName('files');
                        $file= $files[0];
                        if($file!=null)
                        {
                            @unlink('media/downloadcenter/'.$model->file);
                            @unlink('media/downloadcenter/thumbs/120_150'.$model->file);

                            $fileName = md5(microtime().rand()).'_'.$file->name;
                            $file->saveAs(Yii::app()->basePath.'/../media/downloadcenter/'.$fileName);
                            
                             //thumb section
                            $thumb=Yii::app()->phpThumb->create('media/downloadcenter/'.$fileName);
                            $thumb->resize(120,90);
                            $thumb->save('media/downloadcenter/thumbs/120_150'.$fileName);
                            //thumb section
                            
                            $model->file    =  $fileName; 
                            $temp  =  explode('.',$file->name);
                            $model->file_type =    strtoupper($temp[1]);
                        }
			if($model->save())
				$this->redirect(array('index'));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$model  =   $this->loadModel($id);
                @unlink('media/downloadcenter/'.$model->file);
                @unlink('media/downloadcenter/thumbs/120_150'.$model->file);
                $model->delete();
		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Manages all models.
	 */
	public function actionIndex()
	{
		$model=new DownloadCentre('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['DownloadCentre']))
			$model->attributes=$_GET['DownloadCentre'];
                $model->type    =   "dl";

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=DownloadCentre::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='download-centre-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
