<?php
/* @var $this UserController */
/* @var $model User */

$this->breadcrumbs = array(
    'Users' => array('index'),
    'Manage',
);

$this->menu = array(
    array('label' => 'List User', 'url' => array('index')),
    array('label' => 'Create User', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('user-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<div style="width: 99%; padding-left:2%;" id="headlines"><img height="7" width="12" class="right5" src="images/admin/bg.png">Manage User</div>
<div style="height:525px; background-color:#f7eee1;" id="communicationsbox">
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
    <!--<?php //echo CHtml::link('Advanced Search','#',array('class'=>'search-button'));   ?>
    <div class="search-form" style="display:none">
    <?php //$this->renderPartial('_search',array('model'=>$model,)); ?>
    </div>-->

    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'user-grid',
        'dataProvider' => $model->search(),
        'filter' => $model,
        'columns' => array(
            array(
                'header' => 'Sl.No.',
                'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
                'htmlOptions' => array('width' => '5px'),
            ),
            'fullname',
            'company_email_address',
            'last_login',
            /*
              'company_name',
              'mobile_number',
              'country_id',
              'city',
              'industry_id',
              'user_type_id',
              'postal_address',
              'zip',
              'created',
              'isActive',
              'isConfirmed',
              'isRequestedNewPassword',
              'authCode',
             */
            array(
                'name' => 'user_type_id',
                'value' => '$data->userType->type',
                'filter' => UserType::getUserTypes()
            ),
            array(
                'name' => 'isConfirmed',
                'header' => 'Email confirmed?',
                'filter' => array('' => 'All', 'Y' => 'Confirmed', 'N' => 'Not confirmed'),
            ),
            array(
                'header' => 'Resend email',
                'class' => 'CButtonColumn',
                'template' => '{resend_email}',
                'buttons' => array
                    (
                    'resend_email' => array
                        (
                        'visible' => '$data->isConfirmed=="N"',
                        'click' => "	function()
                                        {thiss=	$(this);
                                                $.ajax( 
                                                {  	//change my-grid to your grid's name
                                                	
                                                        type:'POST',
                                                        url:$(this).attr('href'),
                                                        beforeSend:function(data){ thiss.html('<img src=\'images/admin/loading.gif\'/>')},
                                                        success:function(data) 
                                                        {
                                                                alert('Confirm email sent');
                                                                thiss.html('<img src=\'images/admin/email.png\'/>')
                                                        }
                                                })
                                                return false;
                                        }
					",
                        'label' => 'Resend confirm email',
                        'imageUrl' => Yii::app()->request->baseUrl . '/images/admin/email.png',
                        'url' => 'Yii::app()->createUrl("user/resend",array("id"=>$data->id))',
                    ),
                ),
            ),
            array(
                'name' => 'isActive',
                'header' => 'Status',
                'filter' => array('' => 'All', 'Y' => 'Active', 'N' => 'Suspended'),
                'value' => '($data->id!=Yii::app()->user->id)?(CHtml::link(($data->isActive=="Y")?CHtml::image("images/admin/active.png",""):CHtml::image("images/admin/inactive.png",""),"#",array("class"=>"doChangeStatus","id"=>$data->id,"title"=>"Change status"))):"You:Active"',
                'type' => 'raw'
            ),
            array(
                'name' => 'isWalletPaswdRequested',
                'header' => 'Wallet Password Request?',
                'value' => '($data->isWalletPaswdRequested=="Y")?CHtml::image("images/admin/info.gif","Requested a wallet password",array("title"=>"Requested a wallet password")):"No"',
                'filter' => array('' => 'All', 'Y' => 'Yes', 'N' => 'No'),
                'type' => 'raw',
                'htmlOptions' => array('width' => '5px'),
            ),
            array(
                'header' => 'Wallet Actions',
                'class' => 'CButtonColumn',
                'template' => '{change_wallet_password_mail}{change_wallet_password}',
                'buttons' => array
                    (
                    'change_wallet_password' => array
                        (
                        'visible' => '$data->user_type_id!=3 && $data->user_type_id!=2',
                        'click' => "	function()
								{
									if(!confirm('Are you sure you want to change wallet password for this user?')) return false;
									$.fn.yiiGridView.update('user-grid', 
									{  //change my-grid to your grid's name
										type:'POST',
										url:$(this).attr('href'),
										success:function(data) 
										{
											$.fn.yiiGridView.update('user-grid'); 
											alert('wallet password changed for the user');
										}
									})
									return false;
								}
					",
                        'label' => 'Change Wallet Password',
                        'imageUrl' => Yii::app()->request->baseUrl . '/images/admin/wallet.png',
                        'url' => 'Yii::app()->createUrl("user/change_wallet",array("id"=>$data->id))',
                    ),
                    'change_wallet_password_mail' => array
                        (
                        'visible' => '$data->user_type_id!=3 && $data->user_type_id!=2',
                        'click' => "	function()
								{
									if(!confirm('Are you sure you want to change and send wallet password for this user?')) return false;
									$.fn.yiiGridView.update('user-grid', 
									{  //change my-grid to your grid's name
										type:'POST',
										url:$(this).attr('href'),
										success:function(data) 
										{
											$.fn.yiiGridView.update('user-grid'); 
											alert('wallet password sent to the user');
										}
									})
									return false;
								}
					",
                        'label' => 'Send Wallet Password',
                        'imageUrl' => Yii::app()->request->baseUrl . '/images/admin/wallet_mail.png',
                        'url' => 'Yii::app()->createUrl("user/change_wallet",array("id"=>$data->id,"mail"=>true))',
                    ),
                ),
            ),
            array(
                'header' => 'Actions',
                'class' => 'CButtonColumn',
                'template' => '{change_password}{update}{delete}',
                'buttons' => array
                    (
                    'change_password' => array
                        (
                        'label' => 'Change password',
                        'imageUrl' => Yii::app()->request->baseUrl . '/images/admin/change_password.png',
                        'url' => 'Yii::app()->createUrl("user/changepassword",array("id"=>$data->id))',
                    ),
                    'delete' => array
                        (
                        'visible' => '$data->id!=Yii::app()->user->id',
                    ),
                ),
            ),
        ),
    ));
    ?>
</div>
