<?php
/* @var $this RewardController */
/* @var $model Reward */

$this->breadcrumbs = array(
    'Rewards' => array('index'),
    'Manage',
);

$this->menu = array(
    array('label' => 'List Reward', 'url' => array('index')),
    array('label' => 'Create Reward', 'url' => array('create')),
);
?>
<div id="headlines" style="width: 99%; padding-left:2%;">
    <img class="right5" width="12" height="7" src="images/admin/bg.png">
    Manage Rewards
</div>
<div id="communicationsbox" style="height:525px; background-color:#f7eee1;">
    <div id="form_wrapper">
        <div id="row">
            <?php
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'reward-grid',
                'dataProvider' => $model->search(),
                'filter' => $model,
                'columns' => array(
                    array(
                        'header' => 'Sl.No.',
                        'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
                    //'htmlOptions' => array('style' => 'width: 1px;'),
                    ),
                    array(
                        'header' => 'User',
                        'value' => '$data->user->fullname',
                    //'htmlOptions' => array('style' => 'width: 5px;'),
                    ),
                    array(
                        'header' => 'Customer',
                        'value' => '$data->end_customer_name',
                    //'htmlOptions' => array('style' => 'width: 5px;'),
                    ),
                    array(
                        'header' => 'Type',
                        'value' => '$data->is_certification=="Y"?"Certification":"Product"',
                    //'htmlOptions' => array('style' => 'width: 5px;'),
                    ),
                    array(
                        'header' => 'Product/Certification',
                        'value' => '$data->is_certification=="N"?$data->product->product_name:$data->certification->certification_name',
                    //'htmlOptions' => array('style' => 'width: 10px;'),
                    ),
                    array(
                        'header' => 'Serial/Reg. No.',
                        'value' => '$data->serial_number_of_product',
                    //'htmlOptions' => array('style' => 'width: 5px;'),
                    ),
                    array(
                        'header' => 'Points',
                        'value' => '$data->point',
                    //'htmlOptions' => array('style' => 'width: 5px;'),
                    ),
                    array(
                        'header' => 'Purchase/Exam Date.',
                        'value' => '$data->date_of_purchase',
                    //'htmlOptions' => array('style' => 'width: 10px;'),
                    ),
                    array(
                        'header' => 'Invoice No.',
                        'value' => '$data->is_certification=="N"?$data->invoice_number:"-"',
                    //'htmlOptions' => array('style' => 'width: 10px;'),
                    ),
                    array(
                        'name' => 'isActive',
                        'header' => 'Status',
                        'filter' => array('' => 'All', 'Y' => 'Yes', 'N' => 'No'),
                        'value' => 'CHtml::link(($data->isActive=="Y")?CHtml::image("images/admin/active.png",""):CHtml::image("images/admin/inactive.png",""),"#",array("class"=>"doChangeStatus","id"=>$data->id,"title"=>"Change status"))',
                        'type' => 'raw'
                    ),
                    array(
                        'class' => 'CButtonColumn',
                        'header' => '',
                        'template' => '{delete}',
                    //'htmlOptions' => array('style' => 'width: 1px;'),
                    ),
                    array(
                        'header' => '',
                        'value' => 'CHtml::link(CHtml::image("images/dl.png",""),Yii::app()->baseUrl."/media/reward_invoice/".$data->invoice,array("target"=>"_balnk","title"=>"Document/Invoice"))',
                        'type' => 'raw',
                    //'htmlOptions' => array('style' => 'width: 10px;'),
                    ),
                ),
            ));
            ?>
        </div>
    </div>
</div>