<?php

/**
 * This is the model class for table "{{_user_group}}".
 *
 * The followings are the available columns in table '{{_user_group}}':
 * @property string $id
 * @property string $group_name
 * @property string $description
 * @property string $icon
 * @property string $isActive
 */
class UserGroup extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_user_group}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('group_name, description', 'required'),
			array('group_name','unique'),
			array('group_name, icon', 'length', 'max'=>255),
			array('show_in_partner,isActive', 'length', 'max'=>1),
			array('icon', 'file','types'=>'jpg, gif, png', 'allowEmpty'=>true, 'on'=>'update'), // this will allow empty field when page is update (remember here i create scenario update)
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, group_name, description, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'group_name' => 'User Group Name',
			'description' => 'Description',
			'icon' => 'Icon Image',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('group_name',$this->group_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('icon',$this->icon,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	//Get groups
	//param group id, returning model
	public function getGroups($needList=true,$gid=null,$shown_in_partner=null)
	{
		$condition	=	'isActive =  "Y"  ';
		if($gid!=null) 
		$condition	.=	' AND id =  '.$gid;
                
		$model		=	UserGroup::model()->findAll(array('condition'=>$condition,'order'=>'group_name'));
		if($needList)
			return CHtml::listData($model, 'id', 'group_name');
		return $model;
	}
        
        public function userGroupFrontEnd()
        {
            $condition	=	'isActive =  "Y" AND show_in_partner="Y" ';
            $model		=	UserGroup::model()->findAll(array('condition'=>$condition,'order'=>'group_name'));
            return CHtml::listData($model, 'id', 'group_name');		
        }
}
