<?php

/**
 * This is the model class for table "{{_paper}}".
 *
 * The followings are the available columns in table '{{_paper}}':
 * @property string $id
 * @property string $user_id
 * @property string $title_of_the_paper
 * @property string $region_id
 * @property string $user_group_id
 * @property string $product_group_id
 * @property string $product_category_id
 * @property string $product_id
 * @property integer $industry_id
 * @property integer $year
 * @property string $filename
 * @property string $content
 * @property string $date_added
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property User $user
 * @property Country $region
 * @property UserGroup $userGroup
 * @property ProductGroup $productGroup
 * @property ProductCategory $productCategory
 * @property Product $product
 * @property Industry $industry
 */
class Paper extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Paper the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_paper}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, title_of_the_paper, region_id, user_group_id, industry_id, year, filename,image_title,image, content, date_added', 'required'),
			array('industry_id, year', 'numerical', 'integerOnly'=>true),
			array('user_id', 'length', 'max'=>11),
			array('title_of_the_paper, filename,image_title,image', 'length', 'max'=>255),
			array('region_id', 'length', 'max'=>5),
			array('user_group_id, product_group_id, product_category_id, product_id', 'length', 'max'=>20),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_id, title_of_the_paper, region_id, user_group_id, product_group_id, product_category_id, product_id, industry_id, year, filename,image, content, date_added, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
			'region' => array(self::BELONGS_TO, 'Country', 'region_id'),
			'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
			'productGroup' => array(self::BELONGS_TO, 'ProductGroup', 'product_group_id'),
			'productCategory' => array(self::BELONGS_TO, 'ProductCategory', 'product_category_id'),
			'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
			'industry' => array(self::BELONGS_TO, 'Industry', 'industry_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'title_of_the_paper' => 'Title Of The Paper',
			'region_id' => 'Region',
			'user_group_id' => 'User Group',
			'product_group_id' => 'Product Group',
			'product_category_id' => 'Product Category',
			'product_id' => 'Product',
			'industry_id' => 'Industry',
			'year' => 'Year',
			'filename' => 'Attachement',
                        'image' => 'Image',
                        'image_title' => 'Image Title',
			'content' => 'Content',
			'date_added' => 'Date Added',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->with	=	array('user','region','userGroup','productGroup','productCategory','product','industry');
		
		$criteria->compare('id',$this->id,true);
		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('title_of_the_paper',$this->title_of_the_paper,true);
		$criteria->compare('t.region_id',$this->region_id,true);
		$criteria->compare('t.user_group_id',$this->user_group_id,true);
		$criteria->compare('t.product_group_id',$this->product_group_id,true);
		$criteria->compare('t.product_category_id',$this->product_category_id,true);
		$criteria->compare('t.product_id',$this->product_id,true);
		$criteria->compare('t.industry_id',$this->industry_id);
		$criteria->compare('t.year',$this->year);
		$criteria->compare('t.filename',$this->filename,true);
                $criteria->compare('t.image_title',$this->image_title,true);
                $criteria->compare('t.image',$this->image,true);
		$criteria->compare('t.content',$this->content,true);
		$criteria->compare('t.date_added',$this->date_added,true);
		$criteria->compare('t.isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
}