<?php

/**
 * This is the model class for table "{{_reward}}".
 *
 * The followings are the available columns in table '{{_reward}}':
 * @property string $id
 * @property string $user_id
 * @property string $product_id
 * @property string $serial_number_of_product
 * @property integer $point
 * @property string $date_of_entry
 * @property string $date_of_purchase
 * @property string $invoice
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property User $user
 * @property Product $product
 */
class Reward extends CActiveRecord {

    public $sum;
    public $agreement;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Reward the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_reward}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('user_id, product_id, serial_number_of_product, point, date_of_entry, date_of_purchase, invoice, end_customer_name, invoice_number', 'required'),
            array('serial_number_of_product', 'unique', 'message' => 'Already earned points from this product'),
            array('agreement', 'required', 'message' => 'Accept the agreement.'),
            array('agreement', 'compare', 'compareValue' => 1, 'message' => 'You should accept term to use our service'),
            array('certification_id', 'numerical', 'integerOnly' => true),
            array('user_id, product_id', 'length', 'max' => 20),
            array('serial_number_of_product, invoice, point', 'length', 'max' => 255),
            array('isActive,is_certification', 'length', 'max' => 1),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, user_id, product_id, serial_number_of_product, point, date_of_entry, date_of_purchase, invoice, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'user' => array(self::BELONGS_TO, 'User', 'user_id'),
            'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
            'certification' => array(self::BELONGS_TO, 'Certification', 'certification_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'user_id' => 'User',
            'product_id' => 'Product',
            'serial_number_of_product' => 'Serial/Reg No.',
            'point' => 'Point',
            'date_of_entry' => 'Date Of Entry',
            'date_of_purchase' => 'Purchase/Exam date',
            'invoice' => 'Invoice',
            'isActive' => 'Is Active',
            'agreement' => 'I accept the rules and regulations'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->with = array('user', 'product');
        $criteria->compare('t.id', $this->id, true);
        $criteria->compare('user_id', $this->user_id, true);
        $criteria->compare('product_id', $this->product_id, true);
        $criteria->compare('serial_number_of_product', $this->serial_number_of_product, true);
        $criteria->compare('point', $this->point);
        $criteria->compare('date_of_entry', $this->date_of_entry, true);
        $criteria->compare('date_of_purchase', $this->date_of_purchase, true);
        $criteria->compare('invoice', $this->invoice, true);
        $criteria->compare('t.isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => array('pageSize' => Yii::app()->params['defaultPageSize'])
        ));
    }

}