<?php

/**
 * This is the model class for table "{{_training_tools}}".
 *
 * The followings are the available columns in table '{{_training_tools}}':
 * @property string $id
 * @property string $title
 * @property string $content
 * @property string $isLink
 * @property string $href
 * @property string $image_name
 * @property string $isActive
 */
class TrainingTools extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TrainingTools the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_training_tools}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, href, image_name, file', 'length', 'max'=>255),
                        array('content', 'length', 'max'=>500),
                        array('title, image_name, content', 'required'),
                        array('href', 'required','on'=>'link_yes'),
                        array('file', 'required','on'=>'link_no'),
                        array('href', 'url', 'defaultScheme' => 'http'),
			array('isLink, isActive', 'length', 'max'=>1),
			array('content', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, title, content, isLink, href, image_name, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'content' => 'Short description',
			'isLink' => 'Is this points to a Link',
			'href' => 'Link (e.g.,http://www.example.com)',
			'image_name' => 'Icon image (preferred size 120X150)',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('content',$this->content,true);
		$criteria->compare('isLink',$this->isLink,true);
		$criteria->compare('href',$this->href,true);
		$criteria->compare('image_name',$this->image_name,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}