<?php

class SubCategoryController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = 'product';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
            'postOnly + delete', // we only allow deletion via POST request
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            /* array('allow', // allow all users to perform 'index' and 'view' actions
              'actions' => array('login', 'error', 'logout', 'test', 'recover'),
              'users' => array('*'),
              ), */
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'index', 'changeStatus', 'ajaxupdate', 'view', 'Upload', 'admin', 'Delete', 'Loadcategory'),
                'expression' => '$user->isAdmin()'
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new SubCategory;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['SubCategory'])) {
        	
        	$new_sort_order  = 0;
        	if(!empty($_POST['SubCategory']['category_id']))
        	{
        		$SQL = "SELECT MAX(sort_order) AS max_sort_order FROM ptp_sub_category WHERE category_id=".$_POST['SubCategory']['category_id'];
        		$arr_sort_order = Yii::app()->db->createCommand($SQL)->queryAll();
        		$max_sort_order = $arr_sort_order[0]['max_sort_order'];
        	
        		$new_sort_order = $max_sort_order+1;
        	}
            $model->attributes = $_POST['SubCategory'];
            $model->sort_order = $new_sort_order;
            
            if ($model->save())
                $this->redirect(array('index'));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        $category = Category::model()->findAll('main_category_id=:c_id', array(':c_id' => (int) $model->main_category_id));
        $category = CHtml::listData($category, 'id', 'category');

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0 && isset($_POST['SubCategory'])) {
            $model->attributes = $_POST['SubCategory'];
            if ($model->save())
                $this->redirect(array('index'));
        }

        $this->render('create', array(
            'model' => $model,
            'category' => $category,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
    	echo "hi";
  /*       $productcategory = ProductCategory::model()->count('sub_category_id=:ID', array(':ID' => $id));
        $productsubcategory = ProductSubCategory::model()->count('sub_category_id=:ID', array(':ID' => $id));
        //$files=File::model()->findAll(array('condition'=>'category_id=:x', 'params'=>array(':x'=>$id)));
        if (($productcategory == 0) && ($productsubcategory == 0)) {
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else {
            throw new CHttpException(400, Yii::t('app', 'Deletion not possible.'));
            //Yii::app()->user->setFlash('file', "You have no file"); 
            echo '<script> alert("Deletion not possible");</script>';
        } */
    }

    /**
     * Lists all models.
     */
public function actionIndex() {
        $model = new SubCategory('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['SubCategory']))
            $model->attributes = $_GET['SubCategory'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new SubCategory('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['SubCategory']))
            $model->attributes = $_GET['SubCategory'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer $id the ID of the model to be loaded
     * @return SubCategory the loaded model
     * @throws CHttpException
     */
    public function loadModel($id) {
        $model = SubCategory::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param SubCategory $model the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'sub-category-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionLoadcategory() {
        $data = Category::model()->findAll('main_category_id=:c_id', array(':c_id' => (int) $_POST['main_category_id']));
        $data = CHtml::listData($data, 'id', 'category');
        echo CHtml::tag('option', array('value' => ""), CHtml::encode("select"), true);
        foreach ($data as $value => $name)
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
    }

}
