<?php

/**
 * This is the model class for table "{{_product_category}}".
 *
 * The followings are the available columns in table '{{_product_category}}':
 * @property string $id
 * @property string $category_name
 * @property string $isActive
 */
class ProductCategory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_category}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_category,user_group_id,product_group_id', 'required'),
			//array('category_name','unique'),
			array('product_category', 'length', 'max'=>255),
			array('show_in_partner,isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, category_name, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            		'maincategory' => array(self::BELONGS_TO, 'MainCategory', 'main_category_id'),
					 'category' => array(self::BELONGS_TO, 'Category', 'category_id'),
					 'subcategory' => array(self::BELONGS_TO, 'SubCategory', 'sub_category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_group_id'=>'User Group',
			'product_group_id'=>'Product Group',
			'product_category' => 'Product Category',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('t.id',$this->id,true);
		
		$criteria->with	=	array('maincategory','category','subcategory');
		
		$criteria->compare('t.category_id',$this->category_id,true);
		$criteria->compare('t.sub_category_id',$this->sub_category_id,true);
		$criteria->compare('t.product_category',$this->product_category,true);
		$criteria->compare('t.isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	public function getGroupName()
	{
		return $this->category_name.' ('.$this->productGroup->product_group_name."->".$this->userGroup->group_name.')';
	}
	
	//Get Category(s)
	//param group id, returning model
	public function getProductCategory($user_group_id=null,$product_group_id=null,$getAll=false)
	{
		$condition	=	'isActive =  "Y"  ';
		if($user_group_id!=null || $product_group_id!=null)
		{
			if($product_group_id!=null) 
			$condition	.=	' AND product_group_id =  '.$product_group_id;
			if($user_group_id!=null) 
			$condition	.=	' AND user_group_id =  '.$user_group_id;
			
			$model		=	ProductCategory::model()->findAll(array('condition'=>$condition,'order'=>'category_name'));
			return array('0'=>'No category')+CHtml::listData($model, 'id', 'GroupName');
		}
		if($getAll)
		{
			//$model		=	ProductCategory::model()->findAll(array('condition'=>$condition,'order'=>'category_name'));
                        $model		=	ProductCategory::model()->findAll(array('condition'=>$condition,'order'=>'product_category'));
			return array('0'=>'No category')+CHtml::listData($model, 'id', 'product_category');
		}
		return array();
	}
}
