<?php

/**
 * This is the model class for table "{{_sub_category}}".
 *
 * The followings are the available columns in table '{{_sub_category}}':
 * @property integer $id
 * @property integer $main_category_id
 * @property integer $category_id
 * @property string $sub_category
 * @property string $description
 * @property string $image
 * @property string $icon
 * @property string $show_in_partner
 * @property string $isActive
 */
class SubCategory extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_sub_category}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('main_category_id, category_id, sub_category', 'required'),
            array('main_category_id, category_id,sort_order', 'numerical', 'integerOnly' => true),
            array('sub_category, image, icon, banner', 'length', 'max' => 255),
             array('description', 'length', 'max' =>5000), 
            array('show_in_partner, isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, main_category_id, category_id, sub_category, description, image, icon, banner, show_in_partner, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * 
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'maincategory' => array(self::BELONGS_TO, 'MainCategory', 'main_category_id'),
            'category' => array(self::BELONGS_TO, 'Category', 'category_id')
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'main_category_id' => 'Main Category',
            'category_id' => 'Category',
            'sub_category' => 'Sub Category',
            'description' => 'Description',
            'image' => 'Image',
            'icon' => 'Icon',
            'banner'=>'Banner',
            'show_in_partner' => 'Show In Partner',
            'isActive' => 'Is Active',
        	'sort_order' => 'Sort Order'	
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
        $search = trim(Yii::app()->request->getParam('searchterm'));
        $criteria = new CDbCriteria;
        $criteria->with = array('maincategory', 'category');

        $criteria->compare('id', $this->id);
        $criteria->compare('main_category_id', $this->main_category_id);
        $criteria->compare('category_id', $this->category_id);
        $criteria->compare('sub_category', $this->sub_category, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('image', $this->image, true);
        $criteria->compare('icon', $this->icon, true);
        $criteria->compare('banner', $this->banner, true);
        $criteria->compare('show_in_partner', $this->show_in_partner, true);
        $criteria->compare('isActive', $this->isActive, true);
        if (!empty($search)) {
            $criteria->addCondition('t.sub_category like "%' . $search . '%" OR maincategory.main_category like "%' . $search . '%" OR category.category like "%' . $search . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return SubCategory the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getSubCategory($main_category_id = null, $category_id = null) {

        $condition = 'isActive =  "Y"';
        if($main_category_id!=null || $category_id!=null){

        if ($main_category_id != null)
            $condition .= ' AND main_category_id =  ' . $main_category_id;
       
        if ($category_id != null)
            $condition .= ' AND category_id =  ' . $category_id;
        $model = SubCategory::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'sub_category');
        }
       return array();

    }
    
    public function searchSubCategoryForSortOrder($category_id=0) {
    	// @todo Please modify the following code to remove attributes that should not be searched.
    	
    	$criteria = new CDbCriteria;
    	$criteria->with = array('maincategory', 'category');
    
    	if (!empty($category_id)) 
     	{
            $criteria->addCondition('t.category_id='.$category_id, 'AND');
        }
        $criteria->order = 't.sort_order';
    	return new CActiveDataProvider($this, array(
    			'criteria' => $criteria,
    	));
    }

}
