<?php

class TrainingToolsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='resource';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','create','update','admin','delete','ajaxupdate',
				),				
				'expression'=>'$user->isAdmin()'
				),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new TrainingTools;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['TrainingTools']))
		{
                        $model->attributes=$_POST['TrainingTools'];
                        
                        $files   =    CUploadedFile::getInstancesByName('image_name');
                        $file= $files[0];
                        if($file!=null)
                        {
                            $fileName = md5(microtime().rand()).'_'.$file->name;
                            $file->saveAs(Yii::app()->basePath.'/../media/trainingtools/'.$fileName);
                            $thumb=Yii::app()->phpThumb->create('media/trainingtools/'.$fileName);
                            $thumb->resize(120,90);
                            $thumb->save('media/trainingtools/thumbs/120_150'.$fileName);
                            $model->image_name    =  $fileName;                             
                        }
                        $model->scenario = 'link_yes';
                        if($model->isLink=="N")
                        {
                            $model->scenario = 'link_no';
                            $files   =    CUploadedFile::getInstancesByName('file');
                            $file= $files[0];
                            if($file!=null)
                            {
                                $fileName = md5(microtime().rand()).'_'.$file->name;
                                $file->saveAs(Yii::app()->basePath.'/../media/trainingtools/'.$fileName);
                                $model->file    =  $fileName;                             
                            }                            
                        }
                        
			if($model->save())
				$this->redirect(array('index'));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['TrainingTools']))
		{
			$model->attributes=$_POST['TrainingTools'];
                        
                        $files   =    CUploadedFile::getInstancesByName('image_name');
                        $file= $files[0];
                        if($file!=null)
                        {
                            @unlink('media/trainingtools/'.$model->image_name);
                            @unlink('media/trainingtools/thumbs/120_150'.$model->image_name);

                            $fileName = md5(microtime().rand()).'_'.$file->name;
                            $file->saveAs(Yii::app()->basePath.'/../media/trainingtools/'.$fileName);
                            
                             //thumb section
                            $thumb=Yii::app()->phpThumb->create('media/trainingtools/'.$fileName);
                            $thumb->resize(120,90);
                            $thumb->save('media/trainingtools/thumbs/120_150'.$fileName);
                            //thumb section                            
                            $model->image_name    =  $fileName; 
                            
                        }
                        $model->scenario = 'link_yes';
                        if($model->isLink=="N")
                        {
                            $model->scenario    =   'link_no'; 
                            $files   =    CUploadedFile::getInstancesByName('file');
                            $file= $files[0];
                            if($file!=null)
                            {
                                @unlink('media/trainingtools/'.$model->file);
                                $fileName = md5(microtime().rand()).'_'.$file->name;
                                $file->saveAs(Yii::app()->basePath.'/../media/trainingtools/'.$fileName);
                                $model->file    =  $fileName;                             
                            }
                        }
                        if($model->save())
				$this->redirect(array('index'));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$model  = $this->loadModel($id);
		@unlink('media/trainingtools/'.$model->file);
                @unlink('media/trainingtools/'.$model->image_name);
                @unlink('media/trainingtools/thumbs/120_150'.$model->image_name);
                $model->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}


	/**
	 * Manages all models.
	 */
	public function actionIndex()
	{
		$model=new TrainingTools('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['TrainingTools']))
			$model->attributes=$_GET['TrainingTools'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=TrainingTools::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='training-tools-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
