<?php 
$cs = Yii::app()->getClientScript();

$cs->registerScript("loadVendorContact", '
        $(document).ready(function() {

        var table_id ="#tbl_vendor_contact_details";
        var cust_id=$("#hid_cust_id").val();
        var table = $(table_id).DataTable({
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
           "paging": false,
           // pageLength      : 50,
			processing: true,
            ajax: {
                data : {"vendor_id":cust_id},
                url: "' . Yii::app()->createUrl('vendor/GetContactList') . '",
                type: "POST",
                cache : false,
            },
            rowCallback: function(row, data) {
            AddContactContextMenu(row, data);
        },
            aoColumnDefs    : [
                { "bSortable": false, "aTargets": [0,1,2,3] }
                ],
            serverSide:     true,
            fixedColumns:   true,
        } );
        $(".dataTables_scrollFoot").hide();
        function AddContactContextMenu(row, data) {
        $(row).contextMenu({
            selector: "td",
            items: {
                "edit": {
                    name: "Edit",
                    icon: "edit",
                    callback: function () {
                        var contactId = data[4]; 
                        var title = "Edit Contact";
                        loadPopupModal("vendor/VendorContactCreate&id=" + contactId, title, "lg");
                    }
                }
            }
        });
    }
    });', CClientScript::POS_HEAD);
    ?>

<section class="panel">
 <header class="panel-heading clearfix panel-theame">
           Contacts
                <div class="pull-right">
                <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('vendor/VendorContactCreate&c_id=<?php echo $c_id;?> ?>','Add New Contact','lg')" title="Add New Contact"><i class="fa fa-plus"></i> </button>
            </div>
        </header>
</section>

<div class="clearfix"></div>
                <table class="table table-hover table-bordered personal-task" id="tbl_vendor_contact_details">
                    <thead>
                        <tr>
                            <th>Full Name</th>
                            <th>Designation</th>
                            <th>Phone No</th>
                            <th>Status</th>
                            <!-- <th class="text-center"><button class="btn btn-xs btn-theme"  onclick="loadPopupModal('vendor/VendorContactCreate&c_id=<?php echo $c_id;?>','Add New Contact','lg');"><i class="fa fa-plus"></i> ADD</button></th> -->
                        </tr>
                    </thead>
                    
                    <tfoot>
                        <tr>
                            <th>Full Name</th>
                            <th>Designation</th>
                            <th>Phone No</th>
                             <th>Status</th>
                        </tr>
                    </tfoot>
                    
                </table>
         