<?php
$cs = Yii::app()->getClientScript();


?>
<script>
    $(document).ready(function () {
        var table_id = "#supplier_docs_table";
        var cust_id = $("#hid_cust_id").val();

        var table = $(table_id).DataTable({
            scrollY: "250px",
            ajax: {
                data: { "vendor_id": cust_id },
                url: "<?php echo Yii::app()->createUrl('vendor/getDocsList'); ?>",
                type: "POST",
                cache: false
            },
            aoColumnDefs: [
                { "bSortable": false, "aTargets": [0, 3] }
            ],
            bLengthChange: false,
            bInfo: false,
            bPaginate: false,
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            rowCallback: function (row, data) {
                AddDocsContextMenu(row, data);
            }
        });

        $(".dataTables_scrollFoot").hide();

        function AddDocsContextMenu(row, data) {
            var docId = data[5]; // adjust based on server response
            var customerName = data[1]; // adjust if needed

            if (!docId) return; // No context menu if docId is missing

            $(row).contextMenu({
                selector: "td",
                items: {
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["vendor_add"]) || ((int) Yii::app()->user->havePermissionOn["vendor_edit"])) { ?>
                        "edit": {
                            name: "Edit Document",
                            icon: "edit",
                            callback: function () {
                                loadPopupModal(
                                    "vendor/createDocumentform&id=" + docId,
                                    docId + " : " + customerName,
                                    "lg"
                                );
                            }
                        },
                    <?php }
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["vendor_doc_download"])) { ?>
                        "download": {
                            name: "Download",
                            icon: "fa fa-download",
                            callback: function () {
                                window.location.href =
                                    "<?php echo Yii::app()->createUrl('vendor/downloaddocument'); ?>&id=" + docId;
                            }
                        }
                    <?php } ?>
                }
            });
        }
    });
</script>


<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        Documents
        <?php $arr_count = SupplierDocs::model()->findAll(array('condition' => 'supplier_id="' . $model->id . '"')) ?>
        <?php if (COUNT($arr_count) < 2 && Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["vendor_doc_upload"])) { ?>
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" id="add_popup"
                    onclick="loadPopupModal('vendor/createDocumentform&c_id=<?php echo $model->id ?>','Add Document','lg')"
                    title="Add Document"><i class="fa fa-plus"></i></button>
            </div>
        <?php } ?>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="supplier_docs_table">
                <thead>
                    <tr>
                        <th>Sl No</th>
                        <th>Document Name</th>
                        <th>Document No</th>
                        <!-- <th>From Date</th> -->
                        <th>Expiry Date</th>
                        <!-- <th>Actions</th> -->
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
<script type="text/javascript">
    $(document).ready(function () {
        $("div.modal button.close").show();
    });
</script>