<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'change_rack_bin_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<table class="table table-hover table-bordered personal-task" id="tbl_serial_items_table">
    <tr> 
        <th>Item</th>
        <th>Ware House</th>
        <th>Serial No</th>
        <th style="width: 10%;">Old Rack</th>
        <th style="width: 10%;">New Rack</th>
        <th style="width: 10%;">Old Bin</th>    
        <th style="width: 10%;">New Bin</th> 
        <th style="width: 8%;">Total Quantity </th>
        <th style="width: 8%;">Transfer Quantity </th>
    </tr>
    <?php
    if (!empty($model_stock_details)) {
        foreach ($model_stock_details as $i => $each) {
            ?>
            <tr>                
                <td><?php echo $each->product->hiring_part_number; ?></td> 
                <td><?php echo $each->warehouse->warehouse_name; ?></td>  
                <td><?php echo $each->serial_no; ?></td>  
                <td><span id="rack_id_<?php echo $i; ?>"><?php echo $each->rack->name; ?></span></td>  
                <td>
                    <?php echo $form->hiddenField($model_new_location, "[" . $i . "]old_location", array('value' => $each->id)) ?>
                    <?php echo $form->hiddenField($model_new_location, "[" . $i . "]serial_no", array('value' => $each->serial_no)) ?>
                    <?php echo $form->hiddenField($model_new_location, "[" . $i . "]old_rack", array('value' => $each->rack_id)) ?>
                    <?php echo $form->hiddenField($model_new_location, "[" . $i . "]old_bin", array('value' => $each->bin_id)) ?>
                    <?php echo $form->hiddenField($model_new_location, "[" . $i . "]product_id", array('value' => $product_id)) ?>
                    <?php echo $form->hiddenField($model_new_location, "[" . $i . "]warehouse_id", array('value' => $each->warehouse_id)) ?>
                    <?php echo $form->dropDownList($model_new_location, "[" . $i . "]rack_id", MasInvRack::getRacks(), array('class' => 'form-control class_rack_1', 'empty' => 'Select', 'onchange' => 'getrackbin(this.id)')); ?>
                </td>
                <td><span id="bin_id_<?php echo $i; ?>"><?php echo $each->bin->name; ?></span></td>  
                <td>
                    <?php echo $form->dropDownList($model_new_location, "[" . $i . "]bin_id", array(), array('class' => 'form-control', 'empty' => 'Select')); ?>
                </td> 
                <td class="text-center"><span id="quantity_id_<?php echo $i; ?>"><?php echo $each->quantity; ?></span></td>  
                <td>
                    <?php echo CHtml::hiddenField("old_quantity[" . $i . "]", $each->quantity); ?>
                    <?php echo $form->textfield($model_new_location, "[" . $i . "]quantity", array('class' => 'form-control', 'onkeyup' => 'checktransferquantity(this.id);', 'onkeypress' => 'return isPositiveNumber(event)')); ?>
                </td>                 
            </tr>        
            <?php
        }
    } else {
        ?>
        <tr><td colspan="9" class="text-center text-bold">No Data Available</td></tr>
        <?php
    }
    ?>

</table>
<?php if (!empty($model_stock_details)): ?>
    <div class="modal-footer">
        <?php
        $url = Yii::app()->createUrl('storageswap/SaveChangeRackBin');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                        if(data.status=="success"){
                            t8.success("Saved Successfully");
                            location.reload();
                        }else{ 
                            $("#loader").hide();
                                $.each(data, function(key, val) {
                                t8.error(""+val+""); 
                            }); 
                        } 
                    }',
            'beforeSend' => 'function(){     
                        $(".toast8-error").hide(); 
                        var table_length=$("#tbl_serial_items_table").find("tr:gt(0)").length; 
                        for(i=0;i<table_length;i++){
                            var quantity = $("#ProductLocationHiringDetails_"+i+"_quantity").val();
                            if(Number(quantity>0)){
                                $("#loader").show();
                                return true;
                            }
                        }
                        t8.error("Enter quantity in atleast one row");
                        return false;
                    }'
                ), array('id' => 'mybtn' . rand(), 'class' => 'transfer-save-btn btn btn-theme'));
        ?>

    </div>
<?php endif; ?>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("getrackbin", "function getrackbin(field_id){
    var arr_fields= field_id.split('_');
    var model_name= arr_fields[0];
    var row_field= arr_fields[1];  
    var rack_id = $('#ProductLocationHiringDetails_'+row_field+'_rack_id').val(); 
    jQuery.ajax({
        'data' :{'row_field':row_field,'rack_id':rack_id},
        'dataType' : 'json',
        'type':'post',
        'url': '" . Yii::app()->createUrl('storageswap/Getbin') . "',
        'success': function(data) {
          $('#ProductLocationHiringDetails_'+row_field+'_bin_id').html(data.dropdown); 

        }
    });
}", CClientScript::POS_HEAD);
$cs->registerScript("checktransferquantity", " function checktransferquantity(field_id) {
    $('.toast8-error').hide(); 
    var arr_fields= field_id.split('_');
    var model_name= arr_fields[0];
    var row_field= arr_fields[1];  
    var old_loc = $('#ProductLocationHiringDetails_'+row_field+'_old_location').val();
    var rack_id = $('#ProductLocationHiringDetails_'+row_field+'_rack_id').val(); 
    var bin_id = $('#ProductLocationHiringDetails_'+row_field+'_bin_id').val();
    var total_quantity = $('#old_quantity_'+row_field+'').val();
    if(old_loc!=''){
        if(rack_id!=''){
            var table_length=$('#change_rack_bin_items_table').find('tr:gt(0)').length;
            var trsfr_qty=0.00;
            for(i=0;i<=table_length;i++){
                var old_location = $('#ProductLocationHiringDetails_'+i+'_old_location').val();
                var qty = $('#ProductLocationHiringDetails_'+i+'_quantity').val();
                if(Number(old_location)==Number(old_loc) && Number(qty)>0){
                    trsfr_qty+=Number(qty);
                }    
            }	
            if(Number(trsfr_qty)>Number(total_quantity)){
                $('#ProductLocationHiringDetails_'+row_field+'_quantity').val('');
                t8.error('Maximum Quantity Available is '+total_quantity);
                return false;
            }
        }else{
            $('#ProductLocationHiringDetails_'+row_field+'_quantity').val('');
            t8.error('Please Select Rack before entering quantity');
        }
    }
}", CClientScript::POS_HEAD);

?>     