<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'servicestore-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
$baseUrl = Yii::app()->baseUrl;
 ?>
    <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
        <li class="active"><a href="#servicestore_tab1" data-toggle="tab">General</a></li>
        <li><a href="#servicestore_tab2" data-toggle="tab">Details</a></li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="servicestore_tab1">
            <?php $this->renderPartial('general', array('model' => $model, 'form' => $form)); ?>
        </div>
        <div class="tab-pane" id="servicestore_tab2">
            <?php $this->renderPartial('details', array('model' => $model, 'model_item' =>$model_items,'form' => $form)); ?>
        </div>
    </div> 
    <div class="modal-footer">
          <button type="button" class="btn btn-danger" id="servicestore_close" data-dismiss="modal">Close</button>
        <?php
        if($model->id <= 0){
                $url = Yii::app()->createUrl('servicestore/save');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                $("#loader").hide();
                                var servicestore_id= data.id;
                                if(data.status=="success"){  
                                    $("#servicestore_close").click();                                        
                                    t8.success("Service Store Details Saved Successfully!");
                                    reloadTable("#tbl_service_store");
                                } else { 
                                    $("#servicestore-form .servicestore-save-btn").prop("disabled", false);
                                    $("#servicestore-form .servicestore-save-btn").removeClass("btn_loding").addClass("btn-theme"); 
                                    $.each(data, function(key, val) {
                                        $("#servicestore-form #"+key+"_em_").text(val).show(); 
                                        t8.error(""+val+""); 
                                    }); 
                                } 
                            }',
                            'beforeSend' => 'function(){
                                $(".toast8-error").hide();
                                if($("#table-stock-details").find("tr:gt(0)").length > 0){
                                    
                                            var valid = true;
                                            var err = [];
                                            var i,j,needed_qty,sum = 0;
                                            var product_table_len = $("#details_table").find("tr:gt(0)").length;
                                            var product_loc_table_len = $("#table-stock-details").find("tr:gt(0)").length;
                                            for (i=0; i < product_table_len; i++){
                                                if($("#ServiceStoreDetails_"+i+"_quantity").val() > 0){
                                                    sum = 0;
                                                    for (j=0; j < product_loc_table_len; j++){
                                                        if($("#ServiceStoreDetails_"+i+"_product_id").val() === $("#Data_"+j+"_product_id").val()){
                                                            if($("#Data_"+j+"_picked_qty").val() > 0){
                                                                sum += parseFloat($("#Data_"+j+"_picked_qty").val());
                                                            }
                                                        }
                                                    }
                                                    
                                                    if(sum !== ( parseFloat( $("#ServiceStoreDetails_"+i+"_quantity").val() ) * parseFloat( $("#ServiceStoreDetails_"+i+"_factor").val() ) )){
                                                        valid = false;
                                                        err.push("Quantity mismatch for Item "+$("#ServiceStoreDetails_"+i+"_part_number").val());
                                                        
                                                    }
                                                }
                                            }
                                            if(valid){
                                                $("#loader").show();
                                                $("#servicestore-form .servicestore-save-btn").prop("disabled", true);                                
                                
                                            }else{
                                                $.each(err, function(key, val) {
                                                       t8.error(""+val+""); 
                                                }); 
                                                return false;
                                            }
                                           
                                        
                                }else{
                                    t8.error("Enter Quantity and Press Enter to Show Warehouse details!");
                                    return false;
                                }
                                    
                            }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'servicestore-save-btn btn btn-theme'));
        }     
    ?>
    </div>
    <?php $this->endWidget(); ?>
