<?php

$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'upload-price-list-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));



?>


<div class="row">
    <ul class="clearfix form-ul material">
        <li class="col-sm-6">
            <?php echo $form->textField($model, 'pricing_group_name', array('class' => 'tooltipster', 'title' => 'Pricing Group Name', 'data-label' => 'Pricing Group Name <span style="color:red;">*</span>')); ?>

        </li>
        <li class="col-sm-6">
            Document <span style="color:red;">*</span>
            <?php echo $form->hiddenField($model, 'id'); ?>
            <?php echo $form->labelEx($model, 'pricing_group_file_name', array('label' => 'Document ')); ?>
            <?php echo $form->hiddenField($model, 'pricing_group_file_name'); ?>
            <?php echo $form->error($model, 'pricing_group_file_name'); ?>

            <?php
            $allowedExtensions = array("csv");
            $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                'id' => rand(),
                'config' => array(
                    'action' => Yii::app()->createUrl(
                        Yii::app()->controller->id . '/upload',
                        array('folder' => 'upload/pricelist')
                    ),
                    'multiple' => false,
                    'allowedExtensions' => $allowedExtensions,
                    'sizeLimit' => 8 * 1024 * 1024,
                    'onStart' => "js:function(){}",
                    'class' => 'pull-right',
                    'onComplete' => "js:function(id, fileName, responseJSON){
                                     $('#SalesPriceGroupName_pricing_group_file_name').val(responseJSON.filename);
                                    $('.qq-upload-list').html(responseJSON.filename);
                                }",
                )
            ));
            ?>


            <div class="icon_images">
                <input type="hidden" id="uploadfile" />
                <?php if ($model->pricing_group_file_name != '') {
                    echo '<a href ="' . Yii::app()->createUrl("/salespricinggroup/DownloadPriceList") . '&filename=' . $model->pricing_group_file_name . ' " class="btn btn-primary btn-xs">
                        <i class="fa fa-download" title="Download"></i></a>';
                    echo $model->pricing_group_file_name;
                    ?>

                <?php } ?>
            </div>
        </li>

        <li class="col-sm-6">
            <?php echo CHtml::link("<i class='fa fa-download'></i> Download Format", Yii::app()->createUrl('salespricinggroup/downloadsalespricelist'),array('class'=>'btn btn-link')); ?>
        </li>
    </ul>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>

    <?php
    $url = Yii::app()->createUrl('salespricinggroup/SavePricingGroup');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                var id= data.id;
                                if(data.status=="success"){  
                                
                                
                                if(data.errors!="" && data.errors!="undefined"){
                                    t8.error(""+data.errors+""); 
                                }
                                
                                if(data.msg!="" && data.msg!="undefined"){
                                    t8.success(""+data.msg+"");
                                    reloadTable("#tbl_price_group_name");
                                    // location.reload();
                                }
                                
                                $(".x.close").click();
                                /* $.each(data.msg, function(key, val) {
                                            t8.success(""+val+""); 
                                        });
                                     
                                     $.each(data.errors, function(key, val) {
                                            t8.error(""+val+""); 
                                        });
                                        
                                     
                                     t8.success("Saved Successfully!");
                                     $(".x.close").click();
                                     location.reload();*/
                                } else { 
                                     $.each(data, function(key, val) {
                                            $("#upload-price-list-form #"+key+"_em_").text(val).show(); 
                                            t8.error(""+val+""); 
                                        }); 
                                } 
                            }',
        'beforeSend' => 'function(){
                                
                                var file                = $("#SalesPriceGroupName_pricing_group_file_name").val();
                                var pricing_group_name  = $("#SalesPriceGroupName_pricing_group_name").val();
                                if(pricing_group_name==""){
                                    t8.error("Please select Group Name"); 
                                    return false;
                                }
                                else if(file==""){
                                    t8.error("Please Upload a csv file"); 
                                    return false;
                                }

                                $("#upload-price-list-form .enquiry-save-btn").prop("disabled", true);
                                
                                $("#upload-price-list-form .enquiry-save-btn").addClass("btn_loding").removeClass("btn btn-theme"); $(".errorMessage").hide();
                            }',
        'complete' => 'function(){
                                $("#upload-price-list-form .enquiry-save-btn").prop("disabled", false);
                                $("#upload-price-list-form .enquiry-save-btn").addClass("btn btn-theme").removeClass("btn_loading");
                            }'

    ), array('id' => 'mybtn' . rand(), 'class' => 'enquiry-save-btn btn btn-theme'));

    ?>
    <?php //} ?>
</div>


<?php $this->endWidget(); ?>
<style>
    .required {
        display: none !important;
    }
</style>