<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
   <script>
     $(document).ready(function() {
         var table_id ="#tbl_requisition_details";
         var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
             return data;
         }).DataTable({
             scrollY         : "450px",
             pageLength      : 50,
             processing: true,
             ajax: {
                 url: "<?php  echo Yii::app()->createUrl('requisition/getrequisitionlist') ?>",
                 type: "POST",
                 cache : false,
             },
             serverSide:     true,
             fixedColumns:   true,
             processing: true,
		 	  "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
         		$(nRow).addClass("context-menu");
     		},
     });
		
         $('#tbl_requisition_details tbody').on('click', 'tr', function () {
        	 $.contextMenu( 'destroy' );
             var data = table.row( this ).data();
             $.contextMenu({
            	    selector: '.context-menu',
            	    callback: function(key, options) {
                     		var action_id 		= key;
        					var data 			= 	table.row( this ).data();
        					var id				=	data[1];
        					var convert_status 	= 	data[7];
        					if(action_id == "convertenquiry" && convert_status=='Y'){
        						loadPopupModal("enquiry/create&req_id="+id,"Convert to Enquiry - "+id,"xl");
        					}
        					else if(action_id == "convertpo" && convert_status=='Y'){
        						loadPopupModal("purchasingorder/create&req_id="+id,"Convert to Order - "+id,"xl");
        					}
        					else if(action_id == "edit" && convert_status=='Y'){
        						loadPopupModal("requisition/create&id="+id,"Edit Requisition / "+id,"xl");
        					}
        					else if(action_id == "view" && convert_status=='N'){
        						loadPopupModal("requisition/create&id="+id,"View Requisition / "+id,"xl");
        					}
        					else if(action_id == "print"){
        						printreq(id)
        					}
                 },
            	    items: {
            	    	<?php 
            	    	if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_convert_enq"])){?>
                	    	"convertenquiry": {name: "Convert to Enquiry", icon: "fa-retweet"},
                	    <?php } ?>
                	    <?php 
                	    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_convert_po"])){?>
                        	 "convertpo": {name: "Convert to Purchase Order", icon: "fa-retweet"},
                        <?php } ?>
                        <?php 
                        if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_edit"])){?>
                        	"edit": {name: "Edit", icon: "edit"},

                        <?php }
                        if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_view"])){?>
                        	"view": {name: "View", icon: "fa-eye"},           
                        <?php }?>
                        <?php  if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_pdf"])){?>
			                "print": {name: "Print", icon: "fa-print"},        
			            <?php } ?>
                        	    
            	    }
            	});


         });
          
           
  		
     });
        </script>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-info-circle"></i> Requisition  
            <div class="pull-right">
                <?php if(isset(Yii::app()->user->havePermissionOn['requisition_add']) || Yii::app()->user->authorised_user == 1){?>
                <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('requisition/create','Add New Requisition','lg')"><i class="fa fa-plus"></i> ADD</button>
                 <?php }?> <input type="hidden" id="req_ids">
            </div>
           
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_requisition_details">
                    <thead>
                        <tr>
                            <th class="text-center"><a title="Create Enquiry" class="btn btn-theme btn-xs" href="#" onclick="createEnq()" id="select_all"><i class="fa fa-phone"></i></a></th>
                            <th>#</th>
                            <th>Title</th>
                            <th>Date</th>
                            <th>Required Date</th>
                            <th>Reference</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("createPo", "function createEnq(){
                       var req_ids = $('#req_ids').val();
                       if(req_ids == ''){
                            alert('Select Atleast One Requisition!');
                       }else{
                            $('#loader').show();
                            var url = '" . Yii::app()->createUrl('requisition/addenquiry') . "';
                            jQuery.ajax({
                                    'dataType':'json',  
                                    'type':'post',
                                    'url': url,
                                    'data' : {'req_ids':req_ids},
                                    'cache': false,
                                    'success': function(data) {
                                        
                                            if(data.status == 'success'){
                                                $('#loader').hide();
                                                loadPopupModal('enquiry/create&temp_id='+data.id,'Purchase Enquiry','xl');   
                                            }else{
                                                $('#loader').hide();
                                                t8.error('Operation failed!');
                                            }

                                            }

                                   });
                       }
}", CClientScript::POS_HEAD);
$cs->registerScript("getValue", "function getValue(field_id,req_id){
                        
                         var old = $('#req_ids').val();
                         if($('#'+field_id).is(':checked') == true){
                            if(old == ''){
                                   $('#req_ids').val(req_id);
                            }else{
                                   var new_str = old.concat(',',req_id);
                                   $('#req_ids').val(new_str);
                            }
                         }else{
                                        if(old.includes(','+req_id) == true){
                                                $('#req_ids').val(old.replace(','+req_id,''));
                                        }else{
                                                $('#req_ids').val(old.replace(req_id,''));
                                        }
                           
                         }
                         if($('input.req_check:checked').length > 0){   
                            $('.all-selecter').each(function() { $(this).find('button,a').prop('disabled', true); });
                         }else{
                            $('.all-selecter').each(function() { $(this).find('button,a').prop('disabled', false); });
                         }
                         $('#checkAll').prop('checked', false);
                        
                          
}", CClientScript::POS_HEAD);
$cs->registerScript("printreq", "function printreq(id){
    window.open('index.php?r=requisition/PrintRequistionReportPDF&id='+id);
}", CClientScript::POS_HEAD);
