<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Stock Ledger
        <div class="pull-right">
            <div class="filter_details">

                <?php
                $condition = "1=1 AND L.stock_updated='Y' ";
                $model_store = Store::model()->findByPk($product_id);

                if ($from_date != '') {
                    ?>
                    <div class="filter-item">
                        <label> From :</label>
                        <?php echo $from_date ?>
                    </div>
                    <?php
                    $from_date = str_replace('/', '-', $from_date);
                    $from_date = date('Y-m-d', strtotime($from_date));
                    $condition.=" AND transaction_date>='$from_date'";
                }
                ?>
                <?php
                if ($to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label> To :</label>
                        <?php echo $to_date ?>
                    </div>
                    <?php
                    $to_date = str_replace('/', '-', $to_date);
                    $to_date = date('Y-m-d', strtotime($to_date));
                    $condition.=" AND transaction_date<='$to_date'";
                }
                ?>
                <?php
                if ($product_id != '') {
                    ?>
                    <div class="filter-item">
                        <label>Part No :</label>
                        <?php echo $model_store->part_number; ?>
                    </div>
                    <?php
                    $condition.=" AND product_id='$product_id'";
                }
                if ($type != '') {
                    ?>
                    <div class="filter-item">
                        <label>Type :</label>
                        <?php echo $type == 1 ? "Puchase" : "Sales"; ?>
                    </div>
                    <?php
                    if ($type == 1) {
                        $condition.=" AND transaction_from IN ('PURCHASE_QUALITY_CHECK','DEBIT_NOTE')";
                    } else {
                        $condition.=" AND transaction_from IN ('DELIVERY_NOTE','CREDIT_NOTE')";
                    }
                }

                // if($vendor != ''){
                ?>
                <!-- <div class="filter-item">
                    <label>Vendor :</label> -->
                <?php
                //$vendor_details=Vendor::model()->findByPk($vendor);
                // echo $vendor_details->vendor_name;
                ?>
                <!-- </div> -->
                <?php
                // $condition.=" AND transaction_type='DELIVERY_NOTE'"; 
                // }
                // if($customer != ''){
                ?>
                <!-- <div class="filter-item">
                    <label>Customer :</label> -->
                <?php
                //$customer_details=Vendor::model()->findByPk($customer);
                // echo $customer_details->customer_name;
                ?>
                <!-- </div> -->
                <?php
                // }
                ?>

            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Trans.Date</th>
                        <th><?php echo $type == 1 ? "Vendor" : "Customer"; ?></th>
                        <th>Trans.No</th>
                        <th>Type</th>
                        <th>Part No.</th>
                        <th>Description</th>
                        <th>Qty</th>
                        <th>Rate</th>
                        <th>Amount</th>                                              
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $allstockItems = Yii::app()->db->createCommand("SELECT L.*,S.part_number,S.description FROM view_stock_ledger_summary L INNER JOIN erp_store S ON L.product_id=S.id WHERE $condition ORDER BY transaction_date,L.id ASC")->queryAll();
                    $total_qty = $total_amt = 0;
                    ?>
                    <!-- <tr>
                        <td colspan="7" class="text-right"><b> Opening Balance</b></td>
                        <td class="text-right"><b> <?php //echo Yii::app()->numberFormatter->formatCurrency($openingStock, " ");  ?> </b> </td>
                    </tr> -->
                    <?php
                    foreach ($allstockItems as $i => $model) {

                        $in_qty = ( $model['summary_qty'] > 0 ) ? abs($model['summary_qty']) : '';
                        $out_qty = ( $model['summary_qty'] < 0 ) ? abs($model['summary_qty']) : '';
                        if($in_qty!='' && $out_qty){
                        $balance = ( $in_qty - $out_qty ) + $balance;
                       
                        $total_in += $in_qty;
                         }
                        $total_qty+= abs($model['summary_qty']);
                        $total_amt+= abs($model['summary_qty']) * $model['cost_price'];
                        ?>
                        <tr>
                            <td> <?php echo ($i + 1); ?> </td>
                            <td> <?php echo date('d/m/Y', strtotime($model['transaction_date'])); ?> </td>
                            <td> <?php echo $model['customer_vendor_name']; ?> </td>
                            <td> <?php echo $model['header_id']; ?> </td>
                            <td> <?php echo $model['transaction_type']; ?> </td>
                            <td> <?php echo $model['part_number']; ?> </td>
                            <td> <?php echo $model['description']; ?> </td>
                            <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency(abs($model['summary_qty']), " "); ?> </td>
                            <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($model['cost_price'], " "); ?>  </td>
                            <td class="text-right"> <?php
                                $amount = abs($model['summary_qty']) * $model['cost_price'];
                                echo Yii::app()->numberFormatter->formatCurrency($amount, " ");
                                ?>  
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    <tr>
                        <td colspan="7"></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_qty, " "); ?></b></td>
                        <td class="text-right"><b><?php //echo Yii::app()->numberFormatter->formatCurrency($total_out, " ");   ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_amt, " "); ?></b></td>
                    </tr>                        
                </tbody>
            </table>

            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('Export Excel', array('reports/PrintStockLedgerReportExcel', 'from_date' => $from_date, 'to_date' => $to_date, 'product_id' => $product_id, 'type' => $type), array('title' => 'Print Stock Ledger', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
            </div>
        </div>
    </div>
</div>