
<?php
$modlCompy = new MasCompany();
$decimal_point = $modlCompy->no_of_decimals_rate;
?>
<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Sales Reports By Brands
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From Date:</label>
                            <?php echo $from_date ?>
                        </div>
                    <?php
                }
             ?>
            <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To Date :</label>
                            <?php echo $to_date ?>
                        </div>
                    <?php
                }
             ?>
                
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive" style="max-height : 600px">
            
                
                <?php
                $con = '1=1';
                if($brandid>0){
                    $con.= ' AND id="'.$brandid.'"';
                }
                $model_brand = MasInvBrand::model()->findAll(array('condition'=>$con));
                foreach ($model_brand as $model_brand) {
                    $brand_id    = $model_brand->id;
                    $store_count = Store::model()->count(array('condition'=>'t.brand_class_id="'.$brand_id.'"'));
                    if($brand_id>0 AND $store_count>0){
                        ?>
                        <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable html_table">
                            <thead>
                                <tr>
                                    <th colspan="11" style="text-align: center;"><?php echo $model_brand->brand_name; ?> </th>   
                                </tr>
                                <tr>
                                    <th>Item Code</th>
                                    <th>Item Name</th>
                                    <th>Sold Qty</th>
                                    <th>Bonus Qty Sold</th>
                                    <th>Total Qty Sold</th>
                                    <th>Rate</th>
                                    <th>Total</th>
                                    <th>Discount</th>
                                    <th>(Net)</th>                        
                                    <th>Vat</th>
                                    <th>Net Balance After Vat</th>
                                </tr>
                                </thead>
                                <tbody>
                        <?php
                        $model_store = Store::model()->FindAll(array('condition'=>'t.brand_class_id="'.$brand_id.'"'));
                        $sold_qty        = 0;
                        $sold_bonus_qty  = 0;
                        $total_sold_qty  = 0;
                        $total_amt       = 0;
                        $total_discount_amt = 0;
                        $total_net_amt  = 0;
                        $total_vat_amt  = 0;
                        $total_after_vat_amt  = 0;
                        foreach ($model_store as $i => $model_store) {
                            $product_id  = $model_store->id;
                            
                            $condition = '1=1 AND t.product_id="'.$product_id.'"';
                            $condition.= ' AND (invoice.invoice_date BETWEEN  "'.date('Y-m-d',strtotime(str_replace('/', '-', $from_date))).'" AND "'.date('Y-m-d',strtotime(str_replace('/', '-', $to_date))).'" )';
                            
                            $SQL  = "SELECT
                                        GROUP_CONCAT(DISTINCT invoice.id SEPARATOR ',') AS invoice_ids,
                                        GROUP_CONCAT(DISTINCT CN.id SEPARATOR ',') AS creditnote_ids
                                    FROM
                                        `erp_invoice_item` AS t
                                    INNER JOIN erp_invoice AS invoice
                                    ON
                                        invoice.id = t.`invoice_id`
                                    INNER JOIN erp_creditnote AS CN
                                    ON
                                        invoice.id = CN.`invoice_id`
                                    WHERE
                                        ".$condition;
                            $modelItem = Yii::app()->db->createCommand($SQL)->queryAll();
                            $invoice_id = '';
                            $creditnote_id = '';
                            foreach ($modelItem as $eachItem) {
                                $invoice_id     = $eachItem['invoice_ids'];
                                $creditnote_id  = $eachItem['creditnote_ids'];
                            }
                            
                            $qty       = InvoiceItem::model()->with('invoice')->find(array('select'=>'(SUM(t.quantity)) AS quantity','condition'=>$condition,'group'=>'t.product_id'))->quantity;
                            $amount    = InvoiceItem::model()->with('invoice','invoice.currencyname')->find(array('select'=>'(SUM(t.amount*currencyname.exchange_rate)) AS net_amount','condition'=>$condition,'group'=>'t.product_id'))->net_amount;
                            $discount_amt = InvoiceItem::model()->with('invoice','invoice.currencyname')->find(array('select'=>'(SUM(t.deduction_amount*currencyname.exchange_rate)) AS deduction_amount','condition'=>$condition,'group'=>'t.product_id'))->deduction_amount;
                            $vat_amt      = InvoiceItem::model()->with('invoice','invoice.currencyname')->find(array('select'=>'(SUM(t.tax_vat_amount*currencyname.exchange_rate)) AS tax_vat_amount','condition'=>$condition,'group'=>'t.product_id'))->tax_vat_amount;
                            
                            $creditnote_qty = 0;
                            $creditnote_bonus_qty = 0;
                            $creditnote_amount = 0;
                            $creditnote_vat_amt = 0;
                            if(!empty($creditnote_id)){
                                $con = 't.creditnote_id IN ('.$creditnote_id.') AND t.product_id="'.$product_id.'"';
                                $creditnote_qty  = CreditnoteItem::model()->find(array('select'=>'(SUM(t.returned_quantity)) AS returned_quantity','condition'=>$con))->returned_quantity;
                                $creditnote_bonus_qty = CreditnoteItem::model()->find(array('select'=>'(SUM(t.returned_bonus_qty)) AS returned_bonus_qty','condition'=>$con))->returned_bonus_qty;
                                $creditnote_amount    = CreditnoteItem::model()->with('parent','parent.currencyname')->find(array('select'=>'(SUM(t.net_amount*currencyname.exchange_rate)) AS net_amount','condition'=>$con))->net_amount;
                                $creditnote_vat_amt   = CreditnoteItem::model()->with('parent','parent.currencyname')->find(array('select'=>'(SUM(t.tax_vat_amount*currencyname.exchange_rate)) AS tax_vat_amount','condition'=>$con))->tax_vat_amount;
                            }
                            
                            $qty       = $qty-$creditnote_qty;
                            $bonus_qty = $bonus_qty-$creditnote_bonus_qty;
                            $amount    = $amount-$creditnote_amount;
                            $vat_amt    = $vat_amt-$creditnote_vat_amt;
                            
                            $net_amount   = ($amount-$discount_amt)+$vat_amt;
                            $total_amount = $net_amount-$vat_amt;
                            $price  = 0;
                            if($qty>0){
                                $price  = $amount/$qty;
                            }
                            if($qty>0 OR $bonus_qty>0){
                            ?>
                            <tr>
                                <td><?php echo $model_store->part_number." = ".$creditnote_id; ?> </td>
                                <td><?php echo $model_store->description; ?> </td>
                                <td style="text-align: right;"><?php echo number_format((float)$qty, 0, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$bonus_qty, 0, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$qty+$bonus_qty, 0, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$price, $decimal_point, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$amount, $decimal_point, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$discount_amt, $decimal_point, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$net_amount, $decimal_point2, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$vat_amt, $decimal_point, '.', ''); ?></td>
                                <td style="text-align: right;"><?php echo number_format((float)$total_amount, $decimal_point, '.', ''); ?></td>
                            </tr>
                            <?php
                            }
                            $sold_qty+= $qty;
                            $sold_bonus_qty+= $bonus_qty;
                            $total_sold_qty+= $qty+$bonus_qty;
                            $total_amt+= $amount;
                            $total_discount_amt+= $discount_amt;
                            $total_net_amt+= $net_amount;
                            $total_vat_amt+= $vat_amt;
                            $total_after_vat_amt+= $total_amount;
                        }
                        ?>
                        <tr>
                            <td colspan="2"  style="text-align: right;"><b>Total</b></td>
                            <td style="text-align: right;"><?php echo number_format((float)$sold_qty, 0, '.', ''); ?></td>
                            <td style="text-align: right;"><?php echo number_format((float)$sold_bonus_qty, 0, '.', ''); ?></td>
                            <td style="text-align: right;"><?php echo number_format((float)$total_sold_qty, 0, '.', ''); ?></td>
                            <td style="text-align: right;"><?php //echo number_format((float)$qty, 2, '.', ''); ?></td>
                            <td style="text-align: right;"><?php echo number_format((float)$total_amt,$decimal_point, '.', ''); ?></td>
                            <td style="text-align: right;"><?php echo number_format((float)$total_discount_amt, $decimal_point, '.', ''); ?></td>
                            <td style="text-align: right;"><?php echo number_format((float)$total_net_amt, $decimal_point, '.', ''); ?></td>
                            <td style="text-align: right;"><?php echo number_format((float)$total_vat_amt, $decimal_point, '.', ''); ?></td>
                            <td style="text-align: right;"><?php echo number_format((float)$total_after_vat_amt, $decimal_point, '.', ''); ?></td>
                        </tr>
                        </tbody>
                        </table>
                        <?php
                    }
                }
                ?>
            <br>
            <div class="btn-wrap text-center">
                <?php
              //echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF',array('reports/PrintNetSalesReportPDF','from_date'=>$from_date,'to_date'=>$to_date,'customer_id'=>$customer_id , 'inv_type' => $inv_type , 'leadowner_id' => $leadowner_id), array('title'=>'Print Credit List','target'=>'_blank','class' =>  'btn btn-theme')); ?>
  <!--<button type="button" class="btn btn-theme" onclick="excelsaleList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>-->
			  <input type="hidden" value="<?= $from_date ?>" id="from_date">
			  <input type="hidden" value="<?= $to_date ?>" id="to_date">
			  <input type="hidden" value="<?= $brandid ?>" id="brandid">
        </div>
        </div>
    </div>
</div>
<?php $cs = Yii::app()->getClientScript(); 

$cs->registerScript("excelsaleList", "function excelsaleList(){

    var from_date = $('#from_date').val();

    var to_date = $('#to_date').val(); 

    var brandid = $('#brandid').val();
    window.open($('#liveSite').val()+'index.php?r=reports/PrintSaleBrandList&from_date='+from_date+'&to_date='+to_date+'&brandid='+brandid, '_blank');

}", CClientScript::POS_HEAD);