<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Production Summary List
        <div class="pull-right">
            <div class="filter_details">

                <?php
                if ($from_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>From :</label>
                        <?php echo $from_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label> To :</label>
                        <?php echo $to_date ?>
                    </div>

                    <?php
                }
                ?>



            </div>
            <?php

            ?>
        </div>
    </div>
</div>
<div class="panel-body">
    <div class="table-responsive">
        <table id="tbl_order_table" class="table table-fixed table-bordered table-primary html_table">
            <thead>
                <tr>
                    <th>Order</th>
                    <th>PO Date</th>
                    <th>Product</th>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Rate</th>
                    <th>Value</th>
                    <th>Category</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $condition = '1=1';
                if ($from_date != '') {
                    $from_date = str_replace('/', '-', $from_date);
                    $from_date = date('Y-m-d', strtotime($from_date));
                    $condition .= ' AND t.productionorder_date >= "' . $from_date . '"';
                }

                if ($to_date != '') {
                    $to_date = str_replace('/', '-', $to_date);
                    $to_date = date('Y-m-d', strtotime($to_date));
                    $condition .= ' AND t.productionorder_date <= "' . $to_date . '"';
                }

                if ($product_id != '') {
                    $condition .= ' AND t.product_id = "' . $product_id . '"';
                }

                // if ($generic_id != '') {
                //     $condition .= ' AND product.generic_id  = "' . $generic_id . '"';
                // }
                
                // if ($sub_category_id != '') {
                //     $condition .= ' AND product.sub_category_id   = "' . $sub_category_id . '"';
                // }
                
                if (!empty($generic_id)) {
                    if (!is_array($generic_id)) {
                        $generic_id = explode(',', $generic_id); // convert CSV string to array
                    }
                    $categoryIds = array_filter(array_map('intval', $generic_id)); // sanitize
                    if (!empty($categoryIds)) {
                        $condition .= ' AND product.generic_id IN (' . implode(',', $categoryIds) . ')';
                    }
                }

                if (!empty($sub_category_id)) {
                    if (!is_array($sub_category_id)) {
                        $sub_category_id = explode(',', $sub_category_id);
                    }
                    $subCategoryIds = array_filter(array_map('intval', $sub_category_id));
                    if (!empty($subCategoryIds)) {
                        $condition .= ' AND product.sub_category_id IN (' . implode(',', $subCategoryIds) . ')';
                    }
                }

                if ($inventory_type != '') {
                    $condition .= ' AND product.inventory_item_type = "' . $inventory_type . '"';
                }

                // if ((int)$warehouse_id >0) {
                //     $condition .= ' AND  t.warehouse_id  = "' . $warehouse_id . '"';
                // }
                if ($POstatus != '') {
                    $condition .= ' AND t.POstatus = "' . $POstatus . '"';
                }
                // echo $condition;
                // die();
                $model = new ProductionOrder();

                $model = $model->with('product', 'items')->findAll(array('condition' => $condition, 'order' => 't.id DESC', ));

                ?>
                <?php


                foreach ($model as $row) {
                    // echo '<pre>' . print_r($row, true) . '</pre>';

                    // if ($row['POstatus'] != 'C') {
                    if ($row['product']['inventory_item_type'] == 1) {
                        $inventory_item_type = 'Stock Item';
                    }
                    if ($row['product']['inventory_item_type'] == 2) {
                        $inventory_item_type = 'Service Item';
                    }
                    if ($row['product']['inventory_item_type'] == 3) {
                        $inventory_item_type = 'Raw Material';
                    }
                    if ($row['product']['inventory_item_type'] == 4) {
                        $inventory_item_type = 'Bunch';
                    }
                    $inventoryStatus = [
                        'AP' => 'Completed',
                        'O' => 'Open',
                        'C' => 'Cancelled'

                    ];
                    // $total_cost = 0;
                
                    $total_cost = 0;
                    foreach ($row['items'] as $item) {
                        if ($item->quantity > 0 && isset($item->product) && $item->product->rate > 0) {
                            $total_cost += $item->quantity * $item->product->rate;
                        }
                    }

                    $unit_cost = ($row['quantity'] > 0) ? $total_cost / $row['quantity'] : 0;
                    $value = $unit_cost * $row['quantity'];
                    $total_value += $value;


                    $inventory_item_status = isset($inventoryStatus[$row['POstatus']]) ? $inventoryStatus[$row['POstatus']] : 'Unknown';
                    $category_name = MasGeneric::model()->findByPK($row['product']['generic_id'])->generic_name;
                    // $subcategory_name = MasInvSubcategory::model()->findByPK($row['product']['sub_category_id'])->subcategory_name;
                    echo '<tr>';
                    echo '<td>' . htmlspecialchars($row['id']) . '</td>';
                    echo '<td>' . htmlspecialchars(date('d/m/Y', strtotime($row['productionorder_date'])), ) . '</td>';
                    echo '<td>' . htmlspecialchars($row['product']['part_number'], ) . '</td>';
                    echo '<td>' . htmlspecialchars($row['product']['description'], ) . '</td>';
                    echo '<td class="text-right">' . htmlspecialchars(number_format($row['quantity'], 0)) . '</td>';
                    echo '<td class="text-right">' . htmlspecialchars(number_format($unit_cost, 2)) . '</td>';
                    echo '<td class="text-right">' . htmlspecialchars(number_format($value, 2)) . '</td>';
                    echo '<td>' . htmlspecialchars($category_name, ) . '</td>';
                    echo '<td>' . htmlspecialchars($row['POstatus'], ) . '</td>';

                    echo '</tr>';
                    // }
                }
                echo '<tr>';
                echo '<td colspan="6" class="text-right"><strong>Total Amount</strong></td>';
                echo '<td class="text-right"><strong>' . number_format($total_value, 2) . '</strong></td>';
                echo '<td colspan="4"></td>';
                echo '</tr>';
                ?>
            </tbody>
        </table>
        <br>
        <!--- Pdf & excel btns moved to filter page --- commented ---  Ambika --->
        <!--            <div class="btn-wrap text-center">
                
                <a title="Export Pdf" class="btn btn-theme" onclick="purchaseOrderListPDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a> 
                <a title="Export Excel" class="btn btn-theme" onclick="excelPurchaseOrderList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</a>
            
            </div>-->
    </div>
</div>
</div>