<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Out Of Stock List
        <div class="pull-right">
            <div class="filter_details">

                <?php
                if ($from_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>From :</label>
                        <?php echo $from_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label> To :</label>
                        <?php echo $to_date ?>
                    </div>

                    <?php
                }
                ?>
                <?php if (!empty($generic_id) && $generic_id != 'null'): ?>
                    <div class="filter-item">
                        <label>Category :</label>
                        <?php
                        if (!is_array($generic_id)) {
                            $generic_id = explode(',', $generic_id); // ✅ Fix here
                        }
                        $categories = MasGeneric::model()->findAllByPk($generic_id);
                        echo implode(', ', CHtml::listData($categories, 'id', 'generic_name'));
                        ?>
                    </div>
                <?php endif; ?>





            </div>
            <?php

            ?>
        </div>
    </div>
</div>
<div class="panel-body">
    <div class="table-responsive">
        <table id="tbl_order_table" class="table table-fixed table-bordered table-primary">
            <thead>
                <tr>

                    <th>SL.No</th>

                    <th>Produced Item</th>
                    <th>Produced Description</th>
                    <th>RM Item</th>
                    <th>RM Description</th>
                    <th>Produced Qty</th>
                    <th>RM Quantity</th>
                    <th>Available Qty.</th>
                    <th>Diff Qty.</th>
                    <th>Category</th>

                    <th>Inv. Type</th>

                </tr>
            </thead>
            <tbody>
                <?php
                $condition = '1=1';
                if ($from_date != '') {
                    $from_date = str_replace('/', '-', $from_date);
                    $from_date = date('Y-m-d', strtotime($from_date));
                    $condition .= ' AND po.productionorder_date >= "' . $from_date . '"';
                }

                if ($to_date != '') {
                    $to_date = str_replace('/', '-', $to_date);
                    $to_date = date('Y-m-d', strtotime($to_date));
                    $condition .= ' AND po.productionorder_date <= "' . $to_date . '"';
                }

                if ($produced_part_no_id != '') {
                    $condition .= ' AND poi.product_id = "' . $produced_part_no_id . '"';
                }

                if ($product_no != '') {
                    $condition .= ' AND po.product_id = "' . $product_no . '"';
                }

                if (!empty($generic_id)) {
                    if (!is_array($generic_id)) {
                        $generic_id_arr = explode(',', $generic_id); // convert CSV string to array
                    } else {
                        $generic_id_arr = $generic_id;
                    }

                    $categoryIds = array_filter(array_map('intval', $generic_id_arr)); // sanitize
                
                    if (!empty($categoryIds)) {
                        $condition .= ' AND p.generic_id IN (' . implode(',', $categoryIds) . ')';
                    }
                }




                if ($inventory_type != '') {
                    $condition .= ' AND p.inventory_item_type = "' . $inventory_type . '"';
                }

                // Get all available stock quantities in one query
                $stockData = Yii::app()->db->createCommand("
                    SELECT product_id, warehouse_id, SUM(quantity * unit_factor) AS total_qty
                    FROM erp_stock_ledger
                    WHERE stock_updated = 'Y'
                    GROUP BY product_id, warehouse_id
                ")->queryAll();

                // Map for quick access
                $stockMap = [];
                foreach ($stockData as $s) {
                    $key = $s['product_id'] . '_' . $s['warehouse_id'];
                    $stockMap[$key] = $s['total_qty'];
                }

                // Original data query (not grouped)
                $sql = "
                    SELECT
                        po.id AS order_id,
                        po.productionorder_date,
                        p.part_number,
                        p.description,
                        p.inventory_item_type,
                        p.generic_id,
                        poi.product_name AS production_item_name,
                        SUM(GII.picked_qty) AS quantity,
                        poi.product_id as product_id,
                        po.product_id as produced_item,
                        po.description as produced_item_description,
                        po.quantity as produced_quantity

                    FROM
                        erp_production_order_item poi
                    INNER JOIN
                        erp_production_order po ON po.id = poi.production_order_id
                    LEFT JOIN
                        erp_store p ON p.id = poi.product_id
                    LEFT JOIN
                            erp_inventory_goods_issue GI ON GI.reference_id = po.id
                    LEFT JOIN
                        erp_inventory_goods_issue_item GII 
                            ON GII.inventory_goods_issue_id = GI.id 
                            AND GII.product_id = poi.product_id

                    WHERE
                        $condition
                    GROUP BY
                        po.id, poi.product_id
                    ORDER BY
                        product_id ASC, po.id ASC
                ";

                $production_data = Yii::app()->db->createCommand($sql)->queryAll();
                $m = 1;
                // Group data manually by warehouse + production item
                $groupedData = [];
                foreach ($production_data as $row) {
                    $groupKey = $row['warehouse_id'] . '_' . $row['product_id'];

                    if (!isset($groupedData[$groupKey])) {
                        $groupedData[$groupKey] = $row;
                        $groupedData[$groupKey]['quantity'] = (float) $row['quantity'];
                    } else {
                        $groupedData[$groupKey]['quantity'] += (float) $row['quantity'];
                    }
                }

                // Display table
                
                foreach ($groupedData as $row) {
                    $productId = (int) $row['product_id'];
                    $warehouseId = (int) $row['warehouse_id'];
                    $availableQty = isset($stockMap[$productId . '_' . $warehouseId]) ? $stockMap[$productId . '_' . $warehouseId] : 0;

                    $inventoryTypes = [
                        1 => 'Stock Item',
                        2 => 'Service Item',
                        3 => 'Raw Material',
                        4 => 'Bunch',
                    ];
                    $inventory_item_type = isset($inventoryTypes[$row['inventory_item_type']]) ? $inventoryTypes[$row['inventory_item_type']] : 'Unknown';

                    $inventoryStatus = [
                        'AP' => 'Completed',
                        'O' => 'Open',
                        'C' => 'Cancelled'
                    ];
                    $inventory_item_status = isset($inventoryStatus[$row['status']]) ? $inventoryStatus[$row['status']] : 'Unknown';

                    $category_name = '';
                    if (!empty($row['generic_id'])) {
                        $category = MasGeneric::model()->findByPk($row['generic_id']);
                        $category_name = $category ? $category->generic_name : '';
                    }

                    $subcategory_name = '';
                    if (!empty($row['sub_category_id'])) {
                        $subcategory = MasInvSubcategory::model()->findByPk($row['sub_category_id']);
                        $subcategory_name = $subcategory ? $subcategory->subcategory_name : '';
                    }

                    $produced_name = '';
                    if (!empty($row['produced_item'])) {
                        $produced = Store::model()->findByPk($row['produced_item']);
                        $produced_name = $produced ? $produced->part_number : '';
                    }
                    $diff_qty = $availableQty - $row['quantity'];
                    echo '<tr>';
                    echo '<td>' . htmlspecialchars($m++) . '</td>';
                    // echo '<td>' . htmlspecialchars($row['warehouse_name']) . '</td>';
                    echo '<td>' . htmlspecialchars($produced_name) . '</td>';
                    echo '<td>' . htmlspecialchars($row['produced_item_description']) . '</td>';
                    echo '<td>' . htmlspecialchars($row['production_item_name']) . '</td>';
                    echo '<td>' . htmlspecialchars($row['description']) . '</td>';
                    echo '<td class="text-right">' . number_format($row['produced_quantity'], 0) . '</td>';
                    echo '<td class="text-right">' . number_format($row['quantity'], 0) . '</td>';
                    echo '<td class="text-right">' . number_format($availableQty, 0) . '</td>';
                    echo '<td class="text-right">' . number_format($diff_qty, 0) . '</td>';
                    echo '<td>' . htmlspecialchars($category_name) . '</td>';
                    // echo '<td>' . htmlspecialchars($subcategory_name) . '</td>';
                    echo '<td>' . htmlspecialchars($inventory_item_type) . '</td>';
                    // echo '<td>' . htmlspecialchars($inventory_item_status) . '</td>';
                    echo '</tr>';
                }
                ?>
            </tbody>
        </table>
        <br>
        <!--- Pdf & excel btns moved to filter page --- commented ---  Ambika --->
        <!--            <div class="btn-wrap text-center">
                
                <a title="Export Pdf" class="btn btn-theme" onclick="purchaseOrderListPDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a> 
                <a title="Export Excel" class="btn btn-theme" onclick="excelPurchaseOrderList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</a>
            
            </div>-->
    </div>
</div>
</div>