<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '$(document).ready(function() {
        var table_id ="#table_stock_state";
        var table =  $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.to_date = $("#to_date").val();
                        data.generic_id = $("#generic_id").val();
                        data.brand_id = $("#brand_id").val();
                        data.warehouse_id = $("#warehouse_id").val();
                        data.display_type = $("#display_type").val();
                        return data;
                        }).DataTable({
                            //scrollY         : "1000px",
                            pageLength      : 100,
                            ajax: {
                                url: "' . Yii::app()->createUrl('reports/getstockstateasof') . '",
                                type: "POST",
                                cache : false,
                            },
                            "fnDrawCallback": function() {
                                var api = this.api()
                                var json = api.ajax.json();
                                $(api.column(7).footer()).html(Number(json.total).toFixed(2));
                                $(api.column(5).footer()).html(Number(json.totalqty).toFixed(2));
                            },
                            serverSide:     true,
                            fixedColumns:   true,
                            processing: true,
                            "bSort" : false,
                            columns: [
                                {className: ""},
                                {className: ""},
                                {className: ""},               
                                {className: ""},
                                {className: ""},
                                {className: "text-right" },
                                {className: "text-right" },
                                {className: "text-right"},
                            ],
        } );


    });', CClientScript::POS_HEAD);
?>
<section class="panel">
    <div class="panel-heading clearfix panel-theame">
        <div class="top_controls_select col-sm-8"> 
            <div class="col-sm-2">
                <?php echo CHtml::textfield('to_date', date('d/m/Y'), array( 'class' => 'form-control reloaderclass datepicker' )); ?>
            </div>
            <div class="col-sm-3">
                <?php echo CHtml::dropdownlist('generic_id', '', MasGeneric::getGenericNames(), array('class' => 'form-control','prompt' => 'All Generic', 'onchange' => 'reloadTable("#table_stock_state")')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownlist('brand_id', '', ProductClass::getAllProductClass(), array('class' => 'form-control','prompt' => 'All Brand', 'onchange' => 'reloadTable("#table_stock_state")')); ?>
            </div> 
            <div class="col-sm-2">
                <?php echo CHtml::dropdownList('display_type', '', array(2 => 'All Items', 1 => 'Having Stock'), array('class' => 'form-control', 'onChange' => 'reloadTable("#table_stock_state")')); ?>
            </div>
             <div class="col-sm-3">
               <?php 
               if (Yii::app()->user->authorised_user  == 1 || ((int) Yii::app()->user->havePermissionOn["show_warehouse_all"])) {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'prompt' => 'All Warehouse','onChange' => 'reloadTable("#table_stock_state")','data-search'=>'true');
                    $arr_warehouse=MasInventoryWarehouse::getWarehouse();
                    
                } else {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'onChange' => 'reloadTable("#table_stock_state")'); 
                    $arr_warehouse=MasInventoryWarehouse::getUserWarehousees();
                }
                echo CHtml::dropdownlist('warehouse_id', '', $arr_warehouse, $barray);
               
                ?>
            </div>           
        </div>
    </div>
    <div class="panel-body"> 
            <table class="table table-bordered" id="table_stock_state">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Generic</th> 
                        <th>Brand /Class</th>
                        <th>Quantity</th>
                        <th>Rate</th>                        
                        <th>Value</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="5" style="text-align:right">Total:</th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
        <div class="btn-wrap text-center">    
            <button type="button" title="export pdf" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/printstockstate&type=pdf&display_type='+$('#display_type').val()+'&to_date='+$('#to_date').val()+'&generic_id='+$('#generic_id').val()+'&brand_id='+$('#brand_id').val()+'&part_no='+$('div.dataTables_filter input').val()+'&warehouse_id='+$('#warehouse_id').val(), '_blank');"><i class="fa fa-file-pdf-o"></i> PDF</button>
            <button type="button" title="export excel" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/printstockstate&type=excel&display_type='+$('#display_type').val()+'&to_date='+$('#to_date').val()+'&generic_id='+$('#generic_id').val()+'&brand_id='+$('#brand_id').val()+'&part_no='+$('div.dataTables_filter input').val()+'&warehouse_id='+$('#warehouse_id').val(), '_blank');"><i class="fa fa-file-excel-o"></i> Excel</button>  
        </div>
</section>    

<script>
    $('.reloaderclass').on('dp.change', function(e){ 
        reloadTable("#table_stock_state");
    });
</script>