<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '$(document).ready(function() {
        var table_id ="#table_inventory_list";
        var table =  $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.display_type = $("#display_type").val();
                        data.generic_id = $("#generic_id").val();
                        data.brand_id = $("#brand_id").val();
                        data.warehouse_id = $("#warehouse_id").val();
                        data.approved=$("#is_active").val();
                        return data;
                        }).DataTable({
                            //scrollY         : "50vh",
                            pageLength      : 50,
                            ajax: {
                                url: "' . Yii::app()->createUrl('reports/getinventorylist') . '",
                                type: "POST",
                                cache : false,
                            },

                          "fnDrawCallback": function() {
                                var api = this.api()
                                var json = api.ajax.json();
                                $(api.column(8).footer()).html(formatNumber(json.total));
                                $(api.column(6).footer()).html(formatNumber(json.total_qty));
                            },

                            serverSide:     true,
                            fixedColumns:   true,
                            processing: true,
                            "bSort" : false,
                            columns: [
                                {className: ""},
                                {className: ""},
                                {className: ""},
                                {className: ""},
                                {className: ""},
                                {className: "text-right" },
                                {className: "text-right" },
                                {className: "text-right"},
                                {className: "text-right"},
                               
                            ],

        } );

        function formatNumber(val) {
    if (val == null || val === "") return "0.00";

    // Remove existing commas
    val = val.toString().replace(/,/g, "");

    let num = Number(val);
    if (isNaN(num)) return "0.00";

    // Format with comma thousands & 2 decimals
    return num.toLocaleString("en-US", { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}


    });', CClientScript::POS_HEAD);
?>
<section class="panel">
    <div class="panel-heading clearfix panel-theame">
        <div class="top_controls_select">
            <div class="col-sm-2">
                <?php
                $fgeneric = new MasGeneric();
                echo CHtml::dropDownList('generic_id', '0', $fgeneric->getGenericNames(), array('data-label' => 'Category Name', 'onChange' => 'reloadTable("#table_inventory_list")', 'prompt' => '-All Category-', 'class' => 'form-control'));
                // echo CHtml::dropdownList('is_active', '0', array('Y' => 'Approved', 'N' => 'Un Approved'), array('class' => 'form-control', 'onChange' => 'reloadTable("#table_inventory_list")', 'prompt' => '-Type-'));
                ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownList('brand_id', '0', MasInvBrand::getAllBrand(), array('class' => 'form-control', 'onChange' => 'reloadTable("#table_inventory_list")', 'prompt' => '-All Brands-')); ?>
            </div>
            <div class="col-sm-2">
                <?php echo CHtml::dropdownList('display_type', '', array(2 => 'All Items', 1 => 'Having Stock'), array('class' => 'form-control', 'onChange' => 'reloadTable("#table_inventory_list")')); ?>
            </div>

            <div class="col-sm-2">
                <?php
                // echo CHtml::dropdownList('warehouse_id', '', MasInventoryWarehouse::getWarehouses(), array('class' => 'tooltipster form-control', 'prompt' => '-Warehouse-', 'onChange' => 'reloadTable("#table_inventory_list")'));
                ?>


                <?php
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["show_warehouse_all"])) {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'prompt' => 'All Warehouse', 'onChange' => 'reloadTable("#table_inventory_list")', 'data-search' => 'true');
                    $arr_warehouse = MasInventoryWarehouse::getWarehouse();
                } else {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'onChange' => 'reloadTable("#table_inventory_list")');
                    $arr_warehouse = MasInventoryWarehouse::getUserWarehousees();
                }
                echo CHtml::dropdownlist('warehouse_id', '', $arr_warehouse, $barray);
                ?>


            </div>

            <div class="col-sm-2">
                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["current_stock_report_download"]))) { ?>

                    <button type="button" title="export pdf" class="btn btn-theme" onclick="window.open($('#liveSite').val() + 'index.php?r=reports/PrintInventoryReportPDF&display_type=' + $('#display_type').val() + '&brand_id=' + $('#brand_id').val() + '&generic_id=' + $('#generic_id').val() + '&warehouse_id=' + $('#warehouse_id').val(), '_blank');"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>

                    <button type="button" title="export excel" class="btn btn-theme" onclick="window.open($('#liveSite').val() + 'index.php?r=reports/PrintInventoryListExcel&display_type=' + $('#display_type').val() + '&brand_id=' + $('#brand_id').val() + '&generic_id=' + $('#generic_id').val() + '&warehouse_id=' + $('#warehouse_id').val(), '_blank');"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>
                <?php } ?>
            </div>



        </div>
    </div>
    <div class="panel-body">
        <table class="table table-bordered" id="table_inventory_list">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Part No</th>
                    <th>Description</th>
                    <th>Category</th>
                    <th>Brand Name</th>
                    <th>Item Type</th>
                    <th>Qty</th>
                    <th>Cost</th> 
                    <!-- <th>Sale Price</th>  -->
                    <th>Value</th>

                </tr>
            </thead>
            <tfoot>
                <tr>
                    <th colspan="6" style="text-align:right">Total:</th>
                    <th></th>
                    <th></th>
                    <th></th>
                    
                </tr>
            </tfoot>
        </table>
    </div>
    <!--<div class="btn-wrap text-center">-->
    <!--     <button type="button" title="export pdf" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/PrintInventoryReportPDF&display_type='+$('#display_type').val()+'&brand_id='+$('#brand_id').val()+'&warehouse_id='+$('#warehouse_id').val(), '_blank');"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</button> -->

    <!--<button type="button" title="export excel" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=reports/PrintInventoryListExcel&display_type='+$('#display_type').val()+'&brand_id='+$('#brand_id').val()+'&warehouse_id='+$('#warehouse_id').val(), '_blank');"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>  -->
    <!--</div>-->

</section>