<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Gross Profit
        <div class="pull-right">
            <div class="filter_details">

                <?php
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From :</label>
                            <?php echo $from_date ?>
                        </div>
                    <?php
                }
             ?>
            <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To :</label>
                            <?php echo $to_date ?>
                        </div>
                    <?php
                }
             ?>
                <?php
                if ($customer_id != '') {
                    ?>
                    <div class="filter-item">
                        <label>Customer :</label>
                        <?php
                        $c = Customer::model()->findByPK($customer_id);
                        echo $c->customer_name;
                        ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($leadowner_id != '') {
                    ?>
                    <div class="filter-item">
                        <label>Lead Owner :</label>
                        <?php
                        $l = User::model()->findByPK($leadowner_id);
                        echo $l->first_name . " " . $l->last_name;
                        ?>
                    </div>

                    <?php
                }
                ?> 
                <?php
                if($sales_group !=''){
                    ?>
                        <div class="filter-item">
                            <label>Sales Group :</label>
                            <?php $s = MasSalesGroup::model()->findByPK($sales_group);
                                  echo $s->group_name; ?>
                        </div>
                    <?php
                }
             ?>
                <?php
                if ($inv_type > 0) {
                    ?>
                    <div class="filter-item">
                        <label>Invoice Type :</label>
                        <?php
                        $l = MasInvoiceType::model()->findByPK($inv_type);
                        echo $l->inv_name;
                        ?>
                    </div>

                    <?php
                }
                ?>   
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>Sl</th>
                        <th>File ID</th>
                        <th>Invoice No</th>
                        <th>Invoice Date</th>
                        <th>Customer Name</th>                        
                        <th>Currency</th>                        
                        <th>Invoice Value</th> 
                        <th>Value(BC)</th> 
                        <th>Cost</th> 
                        <th>Profit</th> 
                        <th>Profit (%)</th> 
                        <th>Lead Owner </th>
                        <th>Sales Group</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = "1=1";
                    if ($from_date != '') {
                        $from_date1 = str_replace('/', '-', $from_date);
                        $from_date1 = date('Y-m-d', strtotime($from_date1));
                        $condition .= ' AND I.invoice_date >="' . $from_date1 . '"';
                    }
                    if ($to_date != '') {
                        $to_date1 = str_replace('/', '-', $to_date);
                        $to_date1 = date('Y-m-d', strtotime($to_date1));
                        $condition .= ' AND I.invoice_date <="' . $to_date1 . '"';
                    }
                    if ($customer_id != '') {
                        $condition .= ' AND C.id = "' . $customer_id . '"';
                    }
                    if ($sales_group > 0) {
                        $condition .= ' AND I.sales_group_id = "' . $sales_group . '"';
                    }
                    if ($leadowner_id > 0) {
                        $condition .= ' AND (F.lead_owner_id = "' . $leadowner_id . '" OR I.lead_owner_id = "' . $leadowner_id . '")';
                    }
                    if ($inv_type > 0) {
                        $condition .= ' AND I.invoice_type = "' . $inv_type . '"';
                    }
                    $total_invoice_val = $total_profit = $total_cost = 0;
                    $query = 'SELECT 
                        SUM(IT.rate) AS selling_price,
                        I.invoice_date AS invoice_date,
                        I.delivery_ids AS delivery_note_ids,
                        I.file_id AS file_id,
                        I.id AS invoiceid,
                        I.sales_group_id AS sales_group_id,
                        I.exchange_rate AS exchange_rate,
                        CONCAT(IC.inv_code,"-",I.invoice_no) AS invoice_no,
                        C.customer_name AS customer,I.sales_group_id,F.lead_owner_id AS file_lead_owner_id,I.lead_owner_id AS invoice_lead_owner_id,
                        (I.grand_total-I.total_tax_amount) AS  invoice_amt,
                        (I.grand_total-I.total_tax_amount) * I.exchange_rate AS invoice_value_bc,
                        CR.currency_code AS currency_name
                        FROM erp_invoice_item IT
                        LEFT JOIN erp_invoice I ON I.id = IT.invoice_id 
                        LEFT JOIN erp_master_file F ON F.id = I.file_id 
                        LEFT JOIN erp_customer C ON I.customer_id = C.id
                        LEFT JOIN erp_mas_currency CR ON I.currency_id = CR.id
                        LEFT JOIN erp_mas_invoice_type IC ON I.invoice_type = IC.id
                        WHERE ' . $condition . '
                        GROUP BY I.id
                        ORDER BY I.id DESC';
                    $items = Yii::app()->db->createCommand($query)->queryAll();
                    // print_r($items);
                    // die();
                    $no = 0;
                    $invoice_amt =0;
                    foreach ($items as $i => $model) {
                        
                        $exchange_rate  = $model['exchange_rate'];
                        
                        /***************  check credit note amt ***************/
                        $credit_note_amt  = 0;   
                        if($model['invoiceid']>0){
                        $creditNote = Yii::app()->db->createCommand()
                                ->select('sum(credited_amount) as credited_amount')
                                ->from('erp_creditnote')
                                ->where('invoice_id = ' . $model['invoiceid'])
                                ->queryRow();
                        }
                        if($creditNote['credited_amount']>0){
                            $credit_note_amt = $creditNote['credited_amount'];
                        }
                        /************************   end credit Note amt ******************/
                        /***************   check credit note actual cost  ***********************/ 
                        $cn_cost  = 0;                       
                        $model_credit_note = CreditnoteItem::model()->with('parent')->findAll(array('condition' => 'parent.invoice_id IN (' .$model['invoiceid'] . ')'));
                        if (!empty($model_credit_note)){
                            foreach ($model_credit_note as $each) {
                                //$cost += ($each->quantity * $each->cost_price);
                                $cn_product_id  = $each['product_id'];
                                //$cn_quantity    = $each['returned_quantity'];
                                if(!empty($model['delivery_note_ids'])){
                                $model_cn_cost  = StockLedger::model()->find(array('condition' => 'header_id IN (' . $model['delivery_note_ids'] . ') AND product_id="'.$cn_product_id.'"'));
                                }
                                if(empty($model_cn_cost['cost_price']) OR $model_cn_cost['cost_price']<=0){
                                    $model_cn_cost['cost_price'] = 0;
                                }
                                $cn_cost += (($each['returned_quantity']+$each['returned_bonus_qty']) * $model_cn_cost['cost_price']);
                            }
                        }
                        /************************   end credit note actual cost ******************/
                        
                        $actual_invoice_amt = $model['invoice_amt']-$credit_note_amt;
                        $invoice_value_bc   = $actual_invoice_amt*$exchange_rate;
                        
                        //$total_selling_price = $model['invoice_value_bc'];
                        $total_selling_price = $invoice_value_bc;
                        ?>
                        <?php
                        $no++;
                        $cost = 0;
                        if(!empty($model['delivery_note_ids'])){
                        $ledger = StockLedger::model()->find(array('condition' => 'header_id IN (' . $model['delivery_note_ids'] . ')'));
                        }if (!empty($ledger))
                            foreach ($ledger as $each) {
                                $cost += ($each->quantity * $each->cost_price);
                            }
                            
                        $cost  = $cost+$cn_cost;
                        ?>
                        <tr>
                            <td class="text-right"> <?php echo $no; ?></td>
                            <td class="text-right">
                                <?php echo $model['file_id']; ?>
                            </td>
                            <td class="text-right">
                                <?php echo $model['invoiceid']; ?>
                            </td>
                            <?php
                            $date = $model['invoice_date'];
                            if ($date != '0000-00-00') {
                                $newdate = date("d/m/Y", strtotime($date));
                                ?>
                                <td>
                                    <?= $newdate; ?>
                                </td>
                            <?php } else { ?>
                                <td></td>
                            <?php } ?>
                            <td> 
                                <?php echo $model['customer']; ?>
                            </td>
                            <td >
                                <?php echo $model['currency_name']; ?>
                            </td>

                            <td class="text-right"> 
                            <?php 
                            //echo Yii::app()->numberFormatter->formatCurrency($model['invoice_amt'], " ");
                            echo Yii::app()->numberFormatter->formatCurrency($actual_invoice_amt, " ");
                            $invoice_amt +=$actual_invoice_amt;
                            //$invoice_amt +=$model['invoice_amt'];
                            ?>

                            </td>

                            <td class="text-right"> 
                                <?php 
                                echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); 
                                ?>
                                <?php $total_invoice_val += ($total_selling_price); ?> 
                            </td>

                            <td class="text-right"> 
                                <?php echo Yii::app()->numberFormatter->formatCurrency($cost, " "); ?>
                                <?php $total_cost += $cost; ?>
                            </td>

                            <td class="text-right">
                                <?php //echo Yii::app()->numberFormatter->formatCurrency(($total_selling_price - $cost), " "); ?>
                                <?php echo Yii::app()->numberFormatter->formatCurrency(($total_selling_price + $cost), " "); ?>  
                                
                                </td>

                            <?php
                            $total_profit += ($total_selling_price + $cost);
                            $profit_in_percentage =0;
                            if($total_selling_price > 0){
                                $profit_in_percentage = (($total_selling_price + $cost) / $total_selling_price) * 100;
                            }
                            ?>
                            <td class="text-right"><? echo Yii::app()->numberFormatter->formatCurrency($profit_in_percentage," ") ?>  </td>
                            <td class="nw">
                                <?php 
                                if($model['invoice_lead_owner_id'] > 0){
                                    $lead_owner_id = $model['invoice_lead_owner_id'];
                                }
                                else{
                                    $lead_owner_id = $model['file_lead_owner_id'];
                                }
                                $l = User::model()->findByPK($lead_owner_id);
                                    echo $l->fullname; ?>
                            </td>
                            <td class="nw">
                                <?php
                                    echo MasSalesGroup::model()->findByPk($model['sales_group_id'])->group_name;
                                    // var_dump($model['sales_group'])
                                ?>
                            </td>
                        </tr>


                    <?php }
                    ?>
                    <tr>
                        <td colspan="7"> </td>
                        <!--td class="text-right"><b><?php //echo Yii::app()->numberFormatter->formatCurrency($invoice_amt, " "); ?></b> </td-->
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_val, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_cost, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_profit, " "); ?></b><b> 
                                <?php echo $profit; ?></b> </td>
                        
                        <td class="text-right"><b></b> </td>
                        <td colspan="2" class="text-right"><b></b> </td>
                    </tr>

                </tbody>
            </table>
            <br>
           <div class="btn-wrap text-center">
            <?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF',array('reports/PrintGrossProfitReportPDF','from_date'=>$from_date,'to_date'=>$to_date,'customer_id'=>$customer_id,'leadowner_id' => $leadowner_id , 'salesgroup' => $sales_group), array('title'=>'Print Credit List','target'=>'_blank','class' =>  'btn btn-theme'));  ?>
                  <button type="button" class="btn btn-theme" onclick="excelQuoteList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>   
             </div> 
        </div>
    </div>
</div>

<?php $cs = Yii::app()->getClientScript();

$cs->registerScript("excelQuoteList", "function excelQuoteList(){

    var url= '" . Yii::app()->createUrl('reports/PrintGrossProfitExcel') . "';
   
var from_date =  $('#grossprofit_from_date').val();
var to_date =  $('#grossprofit_to_date').val();
var customer_id =  $('#grossprofit_customer_id').val();
var leadowner_id =  $('#grossprofit_leadowner_id').val();
var salesgroup =  $('#grossprofit_sales_group').val();
var inv_type =  $('#grossprofit_invoicetype').val();

var param = '&from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&leadowner_id='+leadowner_id+'&salesgroup='+salesgroup+'&inv_type='+inv_type;
    window.open($('#liveSite').val()+'index.php?r=reports/PrintGrossProfitExcel'+param, '_blank');

}", CClientScript::POS_HEAD);