<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Detailed Good Receipt List
        

        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($receipt_from_date != '') {
                ?>
                    <div class="filter-item">
                        <label>Transaction From :</label>
                        <?php echo $receipt_from_date; ?>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($receipt_to_date != '') {
                ?>
                    <div class="filter-item">
                        <label>Transaction To :</label>
                        <?php echo $receipt_to_date; ?>
                    </div>
                <?php
                }
                ?>


                <?php
                if ($customer_id != '') {
                ?>
                    <div class="filter-item ">
                        <label>Customer :</label>
                        <?php
                        $c = Customer::model()->findByPK($customer_id);
                        echo $c->customer_name;
                        ?>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($warehouse_id != '') {
                ?>
                    <div class="filter-item ">
                        <label>Warehouse :</label>
                        <?php
                        $warehse = MasInventoryWarehouse::model()->findByPK($warehouse_id);
                        echo $warehse->warehouse_name;
                        ?>
                    </div>
                <?php
                }
                ?>


            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">

            <table id="tbl_goodissue_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Receipt #</th>
                        <th>Receipt Date</th>
                        <th>Product</th>
                        <th>Description</th>
                        <th>Warehouse</th>
                        <th>Unit</th>
                        <th>Qty</th>
                        <th>Rate</th>
                        <th>Value</th>
                        <th>Reference</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $total_qty = $total_rate = 0;
                    $condition = '1=1';
                    
                    
                      if ($sort_id == 'receipt_id') { // issue # //inventory_goods_receipt_id
                        $orderby = 't.inventory_goods_receipt_id ASC';
                        } else   if ($sort_id == 'receipt_date') { // Issue Date
                            $orderby = 'inventorygoodsreceipt.goods_receipt_date ASC';
                        } else   if ($sort_id == 'product') { //Product
                            $orderby = 't.product_name ASC';
                        } else { // nill
                            $orderby = 't.id DESC';
                        }

                    if ($receipt_from_date != '') {
                        $receipt_from_date = str_replace('/', '-', $receipt_from_date);
                        $receipt_from_date = date('Y-m-d', strtotime($receipt_from_date));
                        $condition .= ' AND inventorygoodsreceipt.goods_receipt_date >="' . $receipt_from_date . '"';
                    }
                    if ($receipt_to_date != '') {
                        $receipt_to_date = str_replace('/', '-', $receipt_to_date);
                        $receipt_to_date = date('Y-m-d', strtotime($receipt_to_date));
                        $condition .= ' AND inventorygoodsreceipt.goods_receipt_date <="' . $receipt_to_date . '"';
                    }

                    if ($customer_id != '') {
                        $condition .= ' AND inventorygoodsreceipt.customer_id ="' . $customer_id . '"';
                    }

                    if ($goodreceipt_id != '') {
                        $condition .= ' AND inventorygoodsreceipt.id ="' . $goodreceipt_id . '"';
                    }


                    if ((int)$warehouse_id > 0) {
                        $condition .= " AND inventorygoodsreceipt.warehouse_id = " . $warehouse_id;
                    }

                    // $model_goodreceipt = InventoryGoodsReceiptItem::model()->with('inventorygoodsreceipt')->findAll(array('select' => 'sum(picked_qty) as picked_qty,product_name,rate,description,unit','condition' => $condition, 'group' => 'product_id'));

                    $model_goodreceipt = InventoryGoodsReceiptItem::model()->with('inventorygoodsreceipt')->findAll(array('select' => 'inventory_goods_receipt_id,product_id ,rate,picked_qty as picked_qty,product_name,description,unit', 'condition' => $condition,'order' => $orderby));

                    $total_rate = $total_qty = $total_value = 0;
                    foreach ($model_goodreceipt as $i => $model) {
                    ?>

                        <tr>
                            <td>
                                <?php echo $i + 1; ?>
                            </td>
                            <td class="nw"> <?php echo $model->inventory_goods_receipt_id; ?></td>

                            <td class="nw"> <?php echo date('d/m/Y', strtotime($model->inventorygoodsreceipt->goods_receipt_date)); ?></td>

                            <td class="nw"> <?php echo $model->product_name; ?></td>
                            <td class="nw"> <?php echo $model->description; ?></td>
                            <td class="nw"> <?php echo $model->inventorygoodsreceipt->warehouse_det->warehouse_name; ?></td>
                            <td class="nw">
                                <?php echo $model->unitdetails->name; ?>
                            </td>
                            <td class="text-right">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->picked_qty, "");
                                $total_qty += $model->picked_qty;
                                ?>
                            </td>

                            <td class="text-right">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->rate, "");
                                $total_rate += $model->rate;
                                ?>
                            </td>

                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->rate * $model->picked_qty, "");
                                                    $total_value += $model->rate * $model->picked_qty;
                                                    ?></td>


                            <td class="nw">
                                <?php echo $model->inventorygoodsreceipt->reference; ?>
                            </td>

                        </tr>
                    <?php
                    }

                    ?>


                </tbody>
                <tr>
                    <td colspan="7">Total</td>

                    <td class="text-right"> <?php echo   Yii::app()->numberFormatter->formatCurrency($total_qty, ""); ?> </td>
                    <td class="text-right"> </td>
                    <td class="text-right"> <?php echo   Yii::app()->numberFormatter->formatCurrency($total_value, ""); ?> </td>
                    <td></td>

                </tr>
            </table>

            <br />

            <div class="box" style="width: 100%">
                <div class="h12sub-details">
                    <!--Total no:of transportation for this month is <b><?php //echo $total_pallette;
                                                                        ?></b> 
                Total no of Pallete : <b><?php echo $total_pallette; ?></b><br/>
                Total no of Trucks : <b><?php echo $total_trucks; ?></b>-->
                </div>
            </div>

            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('reports/PrintDetailedGoodReceiptReportPDF', 'receipt_from_date' => $receipt_from_date, 'receipt_to_date' => $receipt_to_date, 'customer_shipping_id' => $customer_shipping_id, 'customer_id' => $customer_id, 'goodreceipt_id' => $goodreceipt_id,'warehouse_id' =>$warehouse_id,'sort_id'=>$sort_id), array('title' => 'Export Job Order Pdf', 'target' => '_blank', 'class' => 'btn btn-theme')); 
                ?>
                <button type="button" class="btn btn-theme" onclick="excelItemWisedetailedGoodReceiptList();" title="Export Excel"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>


            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelItemWisedetailedGoodReceiptList", "function excelItemWisedetailedGoodReceiptList(){

    var url= '" . Yii::app()->createUrl('reports/PrintexcelItemWisegoodreceiptList') . "';
    var receipt_from_date = $('#receipt_from_date').val();
    var receipt_to_date = $('#receipt_to_date').val();
    var customer_id = $('#customer_id').val();
    var customer_shipping_id = $('#customer_shipping_id').val();
    var goodreceipt_id = $('#goodreceipt_id').val();
     var warehouse_id = $('#warehouse_id').val();
          var sort_id = $('#sort_id').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintexcelDetailedgoodreceiptList&receipt_from_date='+receipt_from_date+'&goodreceipt_id='+goodreceipt_id+'&receipt_to_date='+receipt_to_date+'&customer_id='+customer_id+ '&customer_shipping_id='+customer_shipping_id+'&warehouse_id='+warehouse_id+'&sort_id='+sort_id, '_blank');

}", CClientScript::POS_HEAD);
