<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Item Wise Good Issue List
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($issue_from_date != '') {
                ?>
                    <div class="filter-item">
                        <label>Transaction From :</label>
                        <?php echo $issue_from_date; ?>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($issue_to_date != '') {
                ?>
                    <div class="filter-item">
                        <label>Transaction To :</label>
                        <?php echo $issue_to_date; ?>
                    </div>
                <?php
                }
                ?>


                <?php
                if ($customer_id != '') {
                ?>
                    <div class="filter-item ">
                        <label>Customer :</label>
                        <?php
                        $c = Customer::model()->findByPK($customer_id);
                        echo $c->customer_name;
                        ?>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($warehouse_id != '') {
                ?>
                    <div class="filter-item ">
                        <label>Warehouse :</label>
                        <?php
                        $warehse = MasInventoryWarehouse::model()->findByPK($warehouse_id);
                        echo $warehse->warehouse_name;
                        ?>
                    </div>
                <?php
                }
                ?>


            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">

            <table id="tbl_goodissue_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Product</th>
                        <th>Description</th>
                        <th>Unit</th>
                        <th>Picked Qty</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';
                    
                       if ($_POST['sort_id'] == 'issue_id') { // issue # //inventory_goods_receipt_id
                        $orderby = 't.inventory_goods_issue_id ASC';
                        } else   if ($_POST['sort_id'] == 'issue_date') { // Issue Date
                        $orderby = 't.inventory_goods_issue_id ASC';
                        } else   if ($_POST['sort_id'] == 'product') { //Product
                            $orderby = 't.product_name ASC';
                        } else { // nill
                            $orderby = 't.id DESC';
                        }
                        

                    if ($issue_from_date != '') {
                        $issue_from_date = str_replace('/', '-', $issue_from_date);
                        $issue_from_date = date('Y-m-d', strtotime($issue_from_date));
                        $condition .= ' AND inventorygoodsissue.goods_issue_date >="' . $issue_from_date . '"';
                    }
                    if ($issue_to_date != '') {
                        $issue_to_date = str_replace('/', '-', $issue_to_date);
                        $issue_to_date = date('Y-m-d', strtotime($issue_to_date));
                        $condition .= ' AND inventorygoodsissue.goods_issue_date <="' . $issue_to_date . '"';
                    }

                    if ($customer_id != '') {
                        $condition .= ' AND inventorygoodsissue.customer_id ="' . $customer_id . '"';
                    }

                    if ($goodissue_id != '') {
                        $condition .= ' AND inventorygoodsissue.id ="' . $goodissue_id . '"';
                    }


                    if ((int)$warehouse_id > 0) {
                        $condition .= " AND inventorygoodsissue.warehouse_id = " . $warehouse_id;
                    }
                    
                     if($issue_type != ''){
                         $condition .= ' AND inventorygoodsissue.issue_type ="' . $issue_type . '"';
                       
                    }
                    
                    

                    $model_goodissue = InventoryGoodsIssueItem::model()->with('inventorygoodsissue')->findAll(array('select' => 'product_id ,inventory_goods_issue_id,sum(picked_qty) as picked_qty,product_name,description,unit', 'condition' => $condition, 'group' => 'product_id','order' => $orderby));
                 $total_free_quantity = $total_qty = $total_value =$total_cost_amount= 0;
                    foreach ($model_goodissue as $i => $model) {

                    ?>

                        <tr>
                            <td>
                                <?php echo ($i + 1); ?>
                            </td>

                            <td class="nw"> <?php echo $model->product_name; ?></td>
                            <td class="nw"> <?php echo $model->description; ?></td>

                            <td class="nw">
                                <?php echo $model->uom->name; ?>
                            </td>
                            
                            <td class="text-right">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($model->picked_qty, "");
                                $total_qty += $model->picked_qty;
                                ?>
                            </td>
                          
                          
                        </tr>
                    <?php
                    }

                    ?>


                </tbody>
                <tr>
                    <td class="text-right" colspan="4"><b>Total</b></td>
                    <td class="text-right"> <?php echo   Yii::app()->numberFormatter->formatCurrency($total_qty, ""); ?> </td>

                </tr>
            </table>

            <br/>


        </div>

        <br>
        <div class="btn-wrap text-center">
            <?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('reports/PrintItemWiseGoodIssueReportPDF', 'issue_from_date' => $issue_from_date, 'issue_to_date' => $issue_to_date, 'customer_shipping_id' => $customer_shipping_id, 'customer_id' => $customer_id, 'goodissue_id' => $goodissue_id, 'warehouse_id' => $warehouse_id,'issue_type' => $issue_type), array('title' => 'Export Pdf', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
            <button type="button" class="btn btn-theme" onclick="excelItemWiseGoodIssueList();" title="Export Excel"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>


        </div>
    </div>
</div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelItemWiseGoodIssueList", "function excelItemWiseGoodIssueList(){

    var url= '" . Yii::app()->createUrl('reports/PrintexcelItemWiseGoodIssueList') . "';
    var issue_from_date      = $('#issue_from_date').val();
    var issue_to_date        = $('#issue_to_date').val();
    var customer_id          = $('#customer_id').val();
    var customer_shipping_id = $('#customer_shipping_id').val();
    var goodissue_id        = $('#goodissue_id').val();
     var warehouse_id       = $('#warehouse_id').val();
    var issue_type          = $('#issue_type').val();

     
    window.open($('#liveSite').val()+'index.php?r=reports/PrintexcelItemWiseGoodIssueList&issue_from_date='+issue_from_date+'&goodissue_id='+goodissue_id+'&issue_to_date='+issue_to_date+'&customer_id='+customer_id+ '&customer_shipping_id='+customer_shipping_id+'&warehouse_id='+warehouse_id+'&issue_type='+issue_type, '_blank');

}", CClientScript::POS_HEAD);
