<!DOCTYPE html>
<html>

<head>
    <title>Purchase Enquiry List</title>
</head>

<body>
    <div class="">
        <?php $this->renderPartial('//common/header'); ?>

        <div class="col-4">
            <br>
        </div>

        <div class="col-4">
            <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 16px;">
                <?php echo strtoupper("PURCHASE ENQUIRY LIST"); ?>
            </div>
        </div>

        <div class="col-4" style="color:#101010;">
            <table class="table" style="width:100%">
                <?php if ($fromdate != '') { ?>
                    <tr>
                        <td style="width:40%"> From Date</td>
                        <td><?php echo $fromdate; ?></td>
                    </tr>
                <?php } ?>

                <?php if ($todate != '') { ?>
                    <tr>
                        <td style="width:40%"> To Date</td>
                        <td><?php echo $todate; ?></td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>
    <br>

    <div class="col-md-12">

        <div class="table-body">
            <table id="tbl_enquiry_table" class="table">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Enquiry ID</th>
                        <th>Enquiry Date</th>
                        <th>Required Date</th>
                        <th>Suppliers</th>
                    </tr>
                </thead>

                <tbody>
                    <?php
                    // Build condition
                    $condition = '1=1';

                    if (!empty($fromdate) && !empty($todate)) {
                        $fromdate = date('Y-m-d', strtotime(str_replace('/', '-', $fromdate)));
                        $todate   = date('Y-m-d', strtotime(str_replace('/', '-', $todate)));
                        $condition .= ' AND t.enquiry_date BETWEEN "' . $fromdate . '" AND "' . $todate . '"';
                    }

                    // Fetch data
                    $model_order = PurchasingEnquiry::model()->findAll(array(
                        'condition' => $condition,
                        'order' => 't.id DESC'
                    ));

                    if (!empty($model_order)) {

                        foreach ($model_order as $i => $row) {
                    ?>
                            <tr>
                                <td><?php echo $i + 1; ?></td>

                                <td><?php echo $row->id; ?></td>

                                <td>
                                    <?php
                                    if ($row->enquiry_date != '0000-00-00' && $row->enquiry_date != '') {
                                        echo date("d/m/Y", strtotime($row->enquiry_date));
                                    } else {
                                        echo "&nbsp;";
                                    }
                                    ?>
                                </td>

                                <td>
                                    <?php
                                    if ($row->required_date != '0000-00-00' && $row->required_date != '') {
                                        echo date("d/m/Y", strtotime($row->required_date));
                                    } else {
                                        echo "&nbsp;";
                                    }
                                    ?>
                                </td>

                                <td>
                                    <?php
                                    $vendor_ids = $row->vendor_id;

                                    if (strpos($vendor_ids, ',') !== false) {
                                        $ids = array_map('trim', explode(',', $vendor_ids));
                                    } else {
                                        $ids = [trim($vendor_ids)];
                                    }

                                    $names = [];
                                    foreach ($ids as $id) {
                                        if ($id != "") {
                                            $names[] = Vendor::getVendorName($id);
                                        }
                                    }

                                    echo implode(", ", $names);
                                    ?>
                                </td>

                            </tr>
                        <?php
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="10">No Data Found</td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>

            </table>
        </div>

        <?php $this->renderPartial("//common/footer"); ?>
    </div>

</body>

</html>
