<!DOCTYPE html>
<html>
<head>
    <title>Vehicle Service / Maintenance Report</title>
</head>
<body>

<div class="panel">
    <?php $this->renderPartial('//common/header'); ?>

    <div class="col-4"><br></div>
    <div class="col-4">
        <div class="h3" style="margin-top:0; margin-bottom:0; text-align:center; font-size:16px;">
            <?php echo strtoupper("Vehicle Service / Maintenance Report"); ?>
        </div>
    </div>

    <div class="col-12">
        <!-- Filter table aligned right -->
        <div class="details-box" style="width:35%; margin-left:auto; float:right;">
            <table class="table" style="width:100%;">
                <?php if ($sheduled_from_date != '') { ?>
                    <tr>
                        <td style="width:50%"><b>Scheduled From :</b></td>
                        <td><?php echo $sheduled_from_date; ?></td>
                    </tr>
                <?php } ?>
                <?php if ($sheduled_to_date != '') { ?>
                    <tr>
                        <td style="width:50%"><b>Scheduled To :</b></td>
                        <td><?php echo $sheduled_to_date; ?></td>
                    </tr>
                <?php } ?>
                 <?php var_dump($_REQUEST);
                 ?>
                <?php 
if (!empty($_REQUEST['vehicle_model'])) {
    $vehicle = MasVehicle::model()->findByPk((int)$_REQUEST['vehicle_model']);
    if ($vehicle) { ?>
        <tr>
            <td style="width:40%"><b>Vehicle</b></td>
            <td><?php echo $vehicle->vehicle_make . ' ' . $vehicle->vehicle_model; ?></td>
        </tr>
<?php 
    } 
} 
?>



            </table>
        </div>
    </div>
</div>
<?php //die; ?>

<div class="panel">
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_vehicle_service" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th style="width:5%;">No</th>
                        <th style="width:20%;">Scheduled Date/Time</th>
                        <th style="width:20%;">Vehicle</th>
                        <th style="width:20%;">Garage</th>
                        <th style="width:20%;">Maintenance Type</th>
                        <th style="width:10%; text-align:right;">Cost</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // ================== CONDITION ==================
                    $condition = "1=1";

                    if (!empty($sheduled_from_date)) {
                        $sheduled_from_date = date("Y-m-d", strtotime(str_replace('/', '-', $sheduled_from_date)));
                        $condition .= " AND DATE(sheduled_date_time) >= '" . $sheduled_from_date . "'";
                    }
                    if (!empty($sheduled_to_date)) {
                        $sheduled_to_date = date("Y-m-d", strtotime(str_replace('/', '-', $sheduled_to_date)));
                        $condition .= " AND DATE(sheduled_date_time) <= '" . $sheduled_to_date . "'";
                    }
                    if ($vehicle_model != '') {
                        $condition .= " AND vehicle_name='" . $vehicle_model . "'";
                    }

                    $services = MasMaintainanceService::model()->findAll([
                        'condition' => $condition,
                        'order' => 'sheduled_date_time ASC'
                    ]);
                    // ================================================

                    $grandTotal = 0;
                    $count = 1;

                    if (!empty($services)) {
                        foreach ($services as $service) {
                            $vehicleType = '';
                            if ($service->vehicle) {
                                $vehicleType = $service->vehicle->vehicle_make . ' ' . $service->vehicle->vehicle_model;
                            }

                            $details = ServiceDetails::model()->findAllByAttributes(['service_id' => $service->id]);

                            if (!empty($details)) {
                                foreach ($details as $detail) {
                                    $maintType = MasMaintainance::model()->findByPk($detail->maintainance_master_id);
                                    $typeName = $maintType ? $maintType->maintainance_type : '--';
                                    $grandTotal += (float)$detail->service_cost;
                    ?>
                                    <tr>
                                        <td><?php echo $count++; ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($service->sheduled_date_time)); ?></td>
                                        <td><?php echo CHtml::encode($vehicleType); ?></td>
                                        <td><?php echo CHtml::encode($service->garage_name); ?></td>
                                        <td><?php echo CHtml::encode($typeName); ?></td>
                                        <td style="text-align:right;"><?php echo number_format((float)$detail->service_cost, 2, '.', ''); ?></td>
                                    </tr>
                    <?php
                                }
                            }
                        }
                    } else {
                    ?>
                        <tr>
                            <td colspan="6" class="bg-total text-center"><b>No Service Details Found</b></td>
                        </tr>
                    <?php } ?>
                </tbody>

                <?php if ($grandTotal > 0) { ?>
                <tfoot>
                    <tr>
                        <td colspan="5" class="text-right" style="font-weight:bold;">Total Cost:</td>
                        <td style="text-align:right; font-weight:bold;"><?php echo number_format($grandTotal, 2, '.', ''); ?></td>
                    </tr>
                </tfoot>
                <?php } ?>
            </table>
        </div>
    </div>
</div>
<?php 
// echo ('Hii');
?>
<?php $this->renderPartial("//common/footer"); ?>

</body>
</html>
