<!DOCTYPE html>
<html>

<head>
    <title>GP Analysis Report</title>
</head>

<style>
    .table {
        border-collapse: collapse !important;
        font-size: 10px;
        color: #101010;
        width: 100%;
    }

    .table thead th {
        background: #1f67b2;
        color: #Fff;
    }

    .table th,
    .table td {
        border: 1px solid #1f67b2 !important;
        text-align: left;
        padding: 3px 6px;
    }

    .table th.text-left,
    .table td.text-left {
        text-align: left;
        text-align: left !important;
    }

    .table th.text-right,
    .table td.text-right {
        text-align: right;
        text-align: right !important;
    }

    .table th.text-center,
    .table td.text-center {
        text-align: center;
        text-align: center !important;
    }

    .table tbody tr:nth-child(even) {
        background: #f4fef3;
    }

    .table th.Table-Title,
    .table td.Table-Title {
        padding: 7px 6px !important;
        font-size: 1.15rem;
        color: green;
        font-weight: 500;
        text-transform: uppercase;
    }

    .table th.total,
    .table td.total {
        background: #1f67b2;
        color: #Fff;
        font-size: 12px;
    }
</style>

<body>
    <div class="heading">
        <?php $this->renderPartial("//common/header", array('warehouse_id' => $warehouse_id)); ?>
        <div class="col-12 text-center" style="margin: 0 auto;">
            <h1><u>GP Analysis Report</u></h1>
        </div>
        <div class="col-12">
            <div class="details-box">
                <table class="table" style="width:100%">
                    <?php if ($from_date != '') {  ?>
                        <tr>
                            <td style="width: 20%"><b>From </b></td>
                            <td>
                                <?php echo   date("d/m/Y", strtotime($from_date)); ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <?php if ($to_date != '') {  ?>
                        <tr>
                            <td style="width: 20%"><b> To</b></td>
                            <td>
                                <?php echo   date("d/m/Y", strtotime($to_date)); ?>
                            </td>
                        </tr>
                    <?php } ?>

                    <?php if ($leadowner_id  > 0) { ?>
                        <tr>
                            <td style="width: 20%"><b>Sales Man</b></td>
                            <td>
                                <?php $l = User::model()->findByPK($leadowner_id);
                                echo $l->first_name . " " . $l->last_name; ?>
                            </td>
                        </tr>
                    <?php } ?>
                    
                    <?php if ($warehouse_id  > 0) { ?>

                        <tr>
                            <td style="width: 20%"><b>Warehouse</b></td>
                            <td>
                                <?php if ($warehouse_id  > 0) { ?>

                                    <?php $l = MasInventoryWarehouse::model()->findByPK($warehouse_id);
                                    echo $l->warehouse_name; ?>

                                <?php } ?>
                            </td>
                        </tr>
                    <?php } ?>
                    
                    
                      


                </table>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    <div class="table-body">
                 <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">

                 <thead>
                        <tr>
                            <th>#</th>
                            <th>Item name</th>
                             <th>Item Description</th>
                            <th>Item Category</th>
                            <th>Item Brand</th>
                            <!--<th>Barcode</th>-->
                            <!-- <th>Item Name</th>-->
                            <th>sales(Qty)</th>
                            <th>Sales Value</th>
                            <th>Cost of Sales</th>
                            <th>Gross Profit</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php

                        $conditionx = 'invoice_status!="C"';
                        $condition_item_cr = 'invoice_id > 0';
                        if ($from_date != '') {
                            $from_date = str_replace('/', '-', $from_date);
                            $from_date = date('Y-m-d', strtotime($from_date));

                            $conditionx .= ' AND invoice_date >="' . $from_date . '"';
                            $condition_item_cr .= ' AND credited_date >="' . $from_date . '"';
                        }
                        if ($to_date != '') {
                            $to_date = str_replace('/', '-', $to_date);
                            $to_date = date('Y-m-d', strtotime($to_date));
                            $conditionx .= ' AND invoice_date <="' . $to_date . '"';
                            $condition_item_cr .= ' AND credited_date <="' . $to_date . '"';
                        }


                        if ($leadowner_id > 0) {
                            $conditionx .= ' AND (created_by ="' . $leadowner_id . '"  )';
                            $condition_item_cr .= ' AND (created_by ="' . $leadowner_id . '"  )';
                        }

                        if ((int)$warehouse_id > 0) {
                            $conditionx .= " AND warehouse_id = " . $warehouse_id;
                            $condition_item_cr .= " AND warehouse_id = " . $warehouse_id;
                        }


                        // ---------------------------------------
                        

                        $SQL_main = 'SELECT product_id,warehouse_id ,invoice_id,invoice_status,generic_id,brand_class_id,sum(quantity) as quantity ,sum(net_amount - tax_vat_amount) as net_amount,sum(tax_vat_amount) as tax_vat_amount 
                        ,description,user_name, warehouse_id,created_by,user_name,part_number,bar_code  FROM view_commission_sales_detailed_report 
                             WHERE  ' .  $conditionx . ' group by  part_number';


                        $model_invoice_details = Yii::app()->db->createCommand($SQL_main)->queryAll();
                        // ---------------------------------------


                        // <!---------------------------------------creditnote----------------------------------------------------------->

                        $sql_cr = "SELECT product_id,credit_id,warehouse_id,invoice_id,generic_id,brand_class_id,created_by,invoice_id,part_number,description,-1*sum(returned_quantity) as quantity ,-1*sum(net_amount) as net_amount,sum(tax_vat_amount) as tax_vat_amount
                            from view_commission_creditnote_detailed_report  WHERE " .  $condition_item_cr . " group by  part_number";

                        $credit_note_list = Yii::app()->db->createCommand($sql_cr)->queryAll();
                        // ---------------------------------------------------

                        $total_qty = $total_amtwotax = $total_amount = $total_costrate = $total_gp = 0;
                        $i = 0;
                        foreach ($model_invoice_details as $key => $row) {

                        ?>
                            <tr>

                                <td><?php echo ($i + 1) ?></td>

                                <td> <?php echo $row['part_number']; ?></td>

                                <td> <?php echo $row['description']; ?></td>

                                <td><?php
                                    $modelMasGeneric = new MasGeneric();
                                    $Generic_name = $modelMasGeneric->findByPK((int)$row['generic_id'])->generic_name;
                                    echo $Generic_name; ?>
                                </td>

                                <td>
                                    <?php
                                    $modelProductClass = new ProductClass();
                                    $brand_name = $modelProductClass->findByPK((int)$row['brand_class_id'])->product_class;
                                    echo $brand_name; ?>
                                </td>


                                <td class="text-right">
                                    <?php
                                    echo Yii::app()->numberFormatter->formatCurrency($row['quantity'], " ");

                                    $total_qty += $row['quantity'];


                                    ?>
                                </td>
                                <td class="text-right">
                                    <?php

                                    echo  Yii::app()->numberFormatter->formatCurrency($row['net_amount'], " ");
                                    $total_amount += $row['net_amount'];
                                    ?>
                                </td>
                                <td class="text-right">
                                    <?php
                                    
                                    $condition_cost = '(transaction_from="DIRECT_INVOICE" OR transaction_from="CANCEL_INVOICE") AND `transaction_date` >= "' . $from_date . '" AND `transaction_date` <= "' . $to_date . '"';
                                    $condition_cost .= ($warehouse_id > 0) ? ' AND warehouse_id = "' . $warehouse_id . '"' : '';
                                    $query = 'SELECT IFNULL(SUM(cost_price * quantity), 0) FROM erp_stock_ledger WHERE ' . $condition_cost . ' AND product_id = "' . $row['product_id'] . '"';
                                    
                                   
                                    $total_cost_rate_inv = Yii::app()->db->createCommand($query)->queryScalar();
                                    $total_cost_rate = abs($total_cost_rate_inv);

                                    echo  Yii::app()->numberFormatter->formatCurrency($total_cost_rate, " ");
                                    $total_costrate += $total_cost_rate;
                                    ?>
                                </td>
                                <td class="text-right">
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($row['net_amount'] - $total_cost_rate, " ");
                                    $total_gp += $row['net_amount'] - $total_cost_rate;
                                    ?>

                                </td>


                            </tr>

                        <?php
                            $i++;
                        }
                        ?>

                        <?php


                        foreach ($credit_note_list as  $credit) {

                        ?>
                            <tr style="background-color: #ffc05026;">

                                <td><?php echo ($i + 1) ?></td>

                                <td> <?php echo $credit['part_number']; ?></td>

                                <td> <?php echo $credit['description']; ?></td>
                                <td><?php
                                    $modelMasGeneric = new MasGeneric();
                                    $Generic_name = $modelMasGeneric->findByPK((int)$credit['generic_id'])->generic_name;
                                    echo $Generic_name; ?>
                                </td>

                                <td>
                                    <?php
                                    $modelProductClass = new ProductClass();
                                    $brand_name = $modelProductClass->findByPK((int)$credit['brand_class_id'])->product_class;
                                    echo $brand_name; ?>
                                </td>


                                <td class="text-right">
                                    <?php
                                    echo Yii::app()->numberFormatter->formatCurrency($credit['quantity'], " ");
                                    $total_qty += ($credit['quantity']);
                                    ?>
                                </td>

                                <td class="text-right">
                                    <?php
                                    echo Yii::app()->numberFormatter->formatCurrency($credit['net_amount'], " ");
                                    $total_amount += $credit['net_amount'];
                                    ?>
                                </td>

                                <td class="text-right">
                                    <?php
                                    
                                    $condition_cost_cr = 'transaction_from="CREDIT_NOTE"  AND `transaction_date` >= "' . $from_date . '" AND `transaction_date` <= "' . $to_date . '"';
                                    $condition_cost_cr .= ($warehouse_id > 0) ? ' AND warehouse_id = "' . $warehouse_id . '"' : '';
                                    $query_cr = 'SELECT IFNULL(-1*SUM(cost_price * quantity), 0) FROM erp_stock_ledger WHERE ' . $condition_cost_cr . ' AND product_id = "' . $credit['product_id'] . '"';
                                    
                                    $total_cost_rate_cr = Yii::app()->db->createCommand($query_cr)->queryScalar();
                                    $total_cost_rate_cr = ($total_cost_rate_cr);
                                    
        
            
                                    echo  Yii::app()->numberFormatter->formatCurrency($total_cost_rate_cr, " ");
                                    $total_costrate += $total_cost_rate_cr;
                                    ?>
                                </td>

                                <td class="text-right">
                                    <?php echo Yii::app()->numberFormatter->formatCurrency(($credit['net_amount'] - $total_cost_rate_cr), " ");
                                    $total_gp += ($credit['net_amount'] - $total_cost_rate_cr);
                                    ?>
                                </td>

                            </tr>

                        <?php
                            $i++;
                        }
                        ?>
                        <tr>
                            <td colspan="5" class="text-right"><b>Total</b> </td>
                            <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_qty, " ");     ?></b> </td>
                            <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_amount, " ");     ?></b> </td>
                            <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_costrate, " ");     ?></b> </td>
                            <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_gp, " ");     ?></b> </td>


                        </tr>

                    </tbody>
                </table>    
    </div>

    <?php
    //$this->renderPartial("//common/footer");
    $this->renderPartial('//common/footer', array('warehouse_id_pass' => $warehouse_id));
    ?>
</body>

</html>